'use strict';

angular.module('rfApp.rffwhid_telemetry', [
    'ngRoute',
    'ngMaterial'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid.telemetry",
            url: "/telemetry",
            templateUrl: "views/rffwhid_telemetry/rffwhid_telemetry.html",
            controller: 'rffwhidTelemetryCtrl'
        });
}]).controller('rffwhidTelemetryCtrl', function($scope, $timeout, RFHelper) {
    $scope.busy = false;

    $scope.telemData = {};

    $scope.getTelemData = function() {
        if ($scope.busy && !$scope.$$destroyed) {
            $scope.updateTelemDataTimeout = $timeout(function () {
                $scope.getTelemData();
            }, 50);
        } else if (!$scope.$$destroyed) {

            $scope.RFFWHID.telem({
                success: function (telemData) {
                    $scope.telemData = telemData;

                    if (!$scope.$$destroyed) {
                        $scope.updateTelemDataTimeout = $timeout(function () {
                            $scope.getTelemData();
                        }, 50);
                    }
                },
                error: function (err) {
                    console.log(err);
                    $scope.updateTelemDataTimeout = $timeout(function () {
                        $scope.getTelemData();
                    }, 50);
                }
            });
        }
    };


    $scope.updateTelemDataTimeout = $timeout(function () {
        $scope.getTelemData();
    }, 50);


    $scope.$on("$destroy", function(){
        $timeout.cancel($scope.updateTelemDataTimeout);
    });


});