'use strict';

angular.module('rfApp.rffwhid_wizard_rca', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
        name: "rffwhid.rffwhid_wizard_rca_step_1",
        url: "/rffwhid_wizard_rca_step_1",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_rca_step1.html",
        controller: 'rffwhidWizardRcaStep1Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_rca_step_2",
        url: "/rffwhid_wizard_rca_step_2",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_rca_step2.html",
        controller: 'rffwhidWizardRcaStep2Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_rca_step_3",
        url: "/rffwhid_wizard_rca_step_3",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_rca_step3.html",
        controller: 'rffwhidWizardRcaStep3Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_rca_step_4",
        url: "/rffwhid_wizard_rca_step_4",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_rca_step4.html",
        controller: 'rffwhidWizardRcaStep4Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_rca_step_5",
        url: "/rffwhid_wizard_rca_step_5",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_rca_step5.html",
        controller: 'rffwhidWizardRcaStep5Ctrl'
    });
}]).controller('rffwhidWizardRcaStep1Ctrl', function($scope, $timeout, $mdDialog, $state, $translate, RFHelper) {
    $scope.next = function () {
        $scope.RFFWHID.wizRc({
            index: 1,
            success: function (wizRc1Data) {
                for (var j=0; j<wizRc1Data.length; j++) {
                    if (wizRc1Data[j].match(/#wiz Move Sticks to extremes, center sticks, place throttle idle, then run wiz rc2/)) {
                        $mdDialog.show({
                            controller: 'loadingDialogCtrl',
                            templateUrl: 'tmpl/loadingDialog.tmpl.html',
                            onComplete: function (dialogScope, element) {
                                dialogScope.title = $translate.instant("rffwhid.rffwhid_wizard_rca_step_1.MOVE_STICKS_TO_EXTREMES_DIALOG_TITLE");
                                dialogScope.status = $translate.instant("rffwhid.rffwhid_wizard_rca_step_1.MOVE_STICKS_TO_EXTREMES_DIALOG_STATUS");
                                dialogScope.buttons = {
                                    'cancel': {
                                        name: $translate.instant("CANCEL"),
                                        action: function () {
                                            $mdDialog.hide();
                                        }
                                    },
                                    'next': {
                                        name: $translate.instant("OK"),
                                        action: function () {
                                            $scope.RFFWHID.wizRc({
                                                index: 2,
                                                success: function (wizRc2Data) {
                                                    $mdDialog.hide();
                                                    $state.go('rffwhid.rffwhid_wizard_rca_step_2');
                                                },
                                                error: function (err) {
                                                    $mdDialog.hide();
                                                    RFHelper.showOkDialog(err.name, err.message).then(function() {
                                                        $scope.busy = false;
                                                    });
                                                }
                                            });
                                        }
                                    }
                                };
                            }
                        });
                        return
                    }
                }

                $mdDialog.hide();
                RFHelper.showOkDialog($translate.instant("ERROR"), $translate.instant("UNEXPECTED_ANSWER")).then(function() {
                    $scope.busy = false;
                });

            },
            error: function (err) {
                $mdDialog.hide();
                RFHelper.showOkDialog(err.name, err.message);
            }
        });
    };
}).controller('rffwhidWizardRcaStep2Ctrl', function($scope, $timeout, $mdDialog, $state, $translate, RFHelper) {
    $scope.wizRc3Status = "Loading...";
    $scope.wizRc3ImgHelp = "";

    $scope.getWizRc3Data = function() {
        if (!$scope.$$destroyed) {
            $scope.RFFWHID.wizRc({
                index: 3,
                success: function (wizRc3Data) {
                    if (!$scope.$$destroyed) {
                        $timeout(function () {
                            for (var j=0; j<wizRc3Data.length; j++) {
                                if (wizRc3Data[j].match(/#wiz Set arm switch to DISARMED and please run wiz rc4/)) {
                                    $mdDialog.hide();
                                    $timeout.cancel($scope.updateWizRc3DataTimeout);
                                    $state.go('rffwhid.rffwhid_wizard_rca_step_3');
                                    return
                                } else if (wizRc3Data[j].match(/#wiz Push Throttle Stick To Top/)) {
                                    $scope.wizRc3Status = $translate.instant("rffwhid.rffwhid_wizard_rca_step_2.SET_THROTTLE_TOP_STATUS");
                                    $scope.wizRc3ImgHelp = "throttletop.png";
                                } else if (wizRc3Data[j].match(/#wiz Push Yaw Stick To Right/)) {
                                    $scope.wizRc3Status = $translate.instant("rffwhid.rffwhid_wizard_rca_step_2.PUSH_YAW_STICK_TO_RIGHT_STATUS");
                                    $scope.wizRc3ImgHelp = "yawright.png";
                                } else if (wizRc3Data[j].match(/#wiz Push Pitch Stick To Top/)) {
                                    $scope.wizRc3Status = $translate.instant("rffwhid.rffwhid_wizard_rca_step_2.PUSH_PITCH_STICK_TO_TOP_STATUS");
                                    $scope.wizRc3ImgHelp = "pitchtop.png";
                                } else if (wizRc3Data[j].match(/#wiz Push Roll Stick To Right/) || wizRc3Data[j].match(/#wiz Set Roll To Right/)) {
                                    $scope.wizRc3Status = $translate.instant("rffwhid.rffwhid_wizard_rca_step_2.PUSH_ROLL_STICK_TO_RIGHT_STATUS");
                                    $scope.wizRc3ImgHelp = "rollright.png";
                                } else {
                                    $scope.wizRc3Status = wizRc3Data[j].replace('#wiz ', '');
                                    $scope.wizRc3ImgHelp = "";
                                }
                            }

                            $scope.updateWizRc3DataTimeout = $timeout(function () {
                                $scope.getWizRc3Data();
                            }, 50);
                        }, 0);
                    } else {
                        $mdDialog.hide();
                        $timeout.cancel($scope.updateWizRc3DataTimeout);
                    }
                },
                error: function (err) {
                    console.log(err.name, err.message);
                    // $mdDialog.hide();
                    // $timeout.cancel($scope.updateWizRxDataTimeout);
                    // RFHelper.showOkDialog(err.name, err.message);
                }
            });
        } else {
            $mdDialog.hide();
            $timeout.cancel($scope.updateWizRxDataTimeout);
        }
    };

    $scope.updateWizRc3DataTimeout = $timeout(function () {
        $scope.getWizRc3Data();
    }, 50);

}).controller('rffwhidWizardRcaStep3Ctrl', function($scope, $timeout, $mdDialog, $state, $translate, RFHelper) {
    $scope.busy = false;

    $scope.next = function () {
        $scope.busy = true;

        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("PROCESSING");
                $scope.RFFWHID.wizRc({
                    index: 4,
                    success: function (wizRc4Data) {
                        $scope.busy = false;
                        if (wizRc4Data.length > 0) {
                            $mdDialog.hide();
                            $state.go('rffwhid.rffwhid_wizard_rca_step_4');
                        } else {
                            $mdDialog.hide();
                            RFHelper.showOkDialog($translate.instant("ERROR"), $translate.instant("EMPTY_ANSWER"));
                        }

                    },
                    error: function (err) {
                        $mdDialog.hide();
                        RFHelper.showOkDialog(err.name, err.message);
                    }
                });
            }
        });
    };
}).controller('rffwhidWizardRcaStep4Ctrl', function($scope, $timeout, $mdDialog, $state,  $translate, RFHelper) {
    $scope.busy = false;

    $scope.next = function () {
        $scope.busy = true;

        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("PROCESSING");
                $scope.RFFWHID.wizRc({
                    index: 5,
                    success: function (wizRc5Data) {
                        $scope.busy = false;

                        for (var j=0; j<wizRc5Data.length; j++) {
                            if (wizRc5Data[j].match(/#wiz Wiz RC Successful/)) {
                                dialogScope.status = $translate.instant("GETTING_NEW_DATA");
                                dialogScope.buttons = null;
                                $scope.RFFWHID.dump({
                                    populateDump: true,
                                    success: function () {
                                        $scope.busy = false;
                                        $mdDialog.hide();
                                        $state.go('rffwhid.rffwhid_wizard_rca_step_5');
                                    },
                                    error: function (err) {
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                                return
                            }
                        }
                        $mdDialog.hide();

                        RFHelper.showConfirmDialog($translate.instant("ERROR"), $translate.instant("rffwhid.rffwhid_wizard_rca_step_4.ERROR_RCA_TRY_AGAIN_CONFIRM_MESSAGE")).then(function () {
                            $state.go('rffwhid.rffwhid_wizard_rca_step_1');
                        }, function () {
                            $state.go('rffwhid.setup');
                        });
                    },
                    error: function (err) {
                        $mdDialog.hide();
                        RFHelper.showOkDialog(err.name, err.message);
                    }
                });
            }
        });
    };
}).controller('rffwhidWizardRcaStep5Ctrl', function($scope, $timeout, $mdDialog, $state) {

});
