'use strict';

angular.module('rfApp.rffwhid_wizard_fix_motor_direction', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
        name: "rffwhid.rffwhid_wizard_fix_motor_direction_step_1",
        url: "/rffwhid_wizard_fix_motor_direction_step_1",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_fix_motor_direction_step1.html",
        controller: 'rffwhidWizardFixMotorDirectionStep1Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_fix_motor_direction_step_2",
        url: "/rffwhid_wizard_fix_motor_direction_step_2",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_fix_motor_direction_step2.html",
        controller: 'rffwhidWizardFixMotorDirectionStep2Ctrl',
        params: {
            currentMotor: 0,
            moutData: {
                'mout1': null,
                'mout2': null,
                'mout3': null,
                'mout4': null
            }
        }
    }).state({
        name: "rffwhid.rffwhid_wizard_fix_motor_direction_step_3",
        url: "/rffwhid_wizard_fix_motor_direction_step_3",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_fix_motor_direction_step3.html",
        controller: 'rffwhidWizardFixMotorDirectionStep3Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_fix_motor_direction_step_4",
        url: "/rffwhid_wizard_fix_motor_direction_step_4",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_fix_motor_direction_step4.html",
        controller: 'rffwhidWizardFixMotorDirectionStep4Ctrl'
    });
}]).controller('rffwhidWizardFixMotorDirectionStep1Ctrl', function($scope, $timeout, $mdDialog, $state, $q, $translate, RFHelper) {
    $scope.propsRemoved = false;
    $scope.busy = false;

    $scope.steps = [5, 7, 10];

    $scope.next = function () {
        $scope.busy = true;

        function fix_motor(step) {

            $mdDialog.show({
                controller: 'loadingDialogCtrl',
                templateUrl: 'tmpl/loadingDialog.tmpl.html',
                onComplete: function (dialogScope, element) {
                    dialogScope.status = $translate.instant("PROCESSING");

                    function setIdlePercent(val) {
                        var deferred = $q.defer();

                        $timeout(function () {
                            dialogScope.status = $translate.instant("rffwhid.rffwhid_wizard_fix_motor_direction_step_1.SET_IDLE_PERCENT_STATUS", {'idle': val});

                            $scope.RFFWHID.idlestop({
                                success: function () {
                                    $scope.RFFWHID.setVar({
                                        varName: 'idle_percent',
                                        varValue: val,
                                        success: function() {
                                            $scope.RFFWHID.save({
                                                success: function() {
                                                    $scope.RFFWHID.dump({
                                                        populateDump: true,
                                                        success: function () {
                                                            deferred.resolve();
                                                        },
                                                        error: function (err) {
                                                            deferred.reject(err);
                                                        }
                                                    });

                                                },
                                                error: function(err) {
                                                    deferred.reject(err);
                                                }
                                            });
                                        },
                                        error: function(err) {
                                            deferred.reject(err);
                                        }
                                    });
                                },
                                error: function (err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);

                        return deferred.promise;
                    }

                    var chainCommands = $q.when();

                    chainCommands = chainCommands.then(function () {
                        return setIdlePercent($scope.steps[step]);
                    }, function(err) {
                        return $q.reject(err);
                    });

                    for (var i=0; i<4; i++) {
                        (function(index) {
                            chainCommands = chainCommands.then(function() {
                                var deferred = $q.defer();

                                $timeout(function () {
                                    dialogScope.status = $translate.instant("rffwhid.rffwhid_wizard_fix_motor_direction_step_1.SPINNING_MOTOR_STATUS", {'motor_number': index+1});

                                    $scope.RFFWHID.idle({
                                        index: index,
                                        success: function () {
                                            deferred.resolve();
                                        },
                                        error: function (err) {
                                            deferred.reject(err);
                                        }
                                    });
                                }, 0);

                                return deferred.promise;
                            }, function(err) {
                                return $q.reject(err);
                            });
                        })(i);
                    }

                    chainCommands = chainCommands.then(function() {
                        step += 1;
                        RFHelper.showConfirmDialog(
                            $translate.instant("INFO"),
                            $translate.instant("rffwhid.rffwhid_wizard_fix_motor_direction_step_1.ARE_ALL_MOTORS_SPINNING_CONFIRM_DIALOG_CONTENT"),
                            $translate.instant("NO"),
                            $translate.instant("YES")
                        ).then(function() {
                            $scope.RFFWHID.idlestop({
                                success: function () {
                                    $scope.busy = false;
                                    $mdDialog.hide();
                                    $state.go('rffwhid.rffwhid_wizard_fix_motor_direction_step_2', {
                                        currentMotor: 0,
                                        moutData: {
                                            'mout1': null,
                                            'mout2': null,
                                            'mout3': null,
                                            'mout4': null
                                        }
                                    });
                                },
                                error: function(err) {
                                    $scope.busy = false;
                                    $mdDialog.hide();
                                    RFHelper.showOkDialog(err.name, err.message);
                                }
                            });
                        }, function() {
                            if (step < $scope.steps.length) {
                                fix_motor(step);
                            } else {
                                $scope.RFFWHID.idlestop({
                                    success: function () {
                                        $scope.busy = false;
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog($translate.instant("WARNING"), $translate.instant("rffwhid.rffwhid_wizard_fix_motor_direction_step_1.OTHER_ISSUE_WITH_MOTORS_DIALOG_MESSAGE"));
                                    },
                                    error: function(err) {
                                        $scope.busy = false;
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                            }
                        });
                    }, function(err) {
                        $scope.busy = false;
                        $mdDialog.hide();
                        RFHelper.showOkDialog(err.name, err.message);
                    });

                }
            });

        }

        fix_motor(0);
    };

}).controller('rffwhidWizardFixMotorDirectionStep2Ctrl', function($scope, $timeout, $mdDialog, $state, $stateParams, $translate, $q, RFHelper) {
    $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
    $scope.motorSpinning = false;
    $scope.currentMotor = parseInt($stateParams.currentMotor);
    $scope.moutData = $stateParams.moutData;
    $scope.mout = null;

    $scope.resetMoutValues = function () {
        $scope.busy = true;
        $scope.RFDump['set']['mout1'] = 0;
        $scope.RFDump['set']['mout2'] = 1;
        $scope.RFDump['set']['mout3'] = 2;
        $scope.RFDump['set']['mout4'] = 3;

        RFHelper.saveRFFWHIDRFDumpDialog({
            'RFFWHID': $scope.RFFWHID,
            'modifiedDump': $scope.RFDump,
            success: function(RFFWHID) {
                $scope.RFFWHID = RFFWHID;
                $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
                $scope.busy = false;
                $scope.toggleMotorSpinning($scope.currentMotor);
            },
            error: function (err) {
                $scope.busy = false;
                if (err.message == 'Values are the same') {
                    $scope.toggleMotorSpinning($scope.currentMotor);
                } else {
                    RFHelper.showOkDialog(err.name, err.message);
                }
            }
        });
    };

    $scope.toggleMotorSpinning = function (index, callback) {
        $scope.busy = true;

        var chainCommands = $q.when();

        if ($scope.motorSpinning) {
            chainCommands = chainCommands.then(function() {
                var deferred = $q.defer();

                $timeout(function () {
                    $scope.RFFWHID.idlestop({
                        success: function () {
                            $scope.motorSpinning = false;
                            deferred.resolve();
                        },
                        error: function(err) {
                            deferred.reject(err);
                        }
                    });
                }, 0);

                return deferred.promise;
            }, function(err) {
                return $q.reject(err);
            });

        } else {
            chainCommands = chainCommands.then(function() {
                var deferred = $q.defer();

                $timeout(function () {
                    $scope.RFFWHID.idle({
                        index: index,
                        success: function () {
                            $scope.motorSpinning = true;
                            deferred.resolve();
                        },
                        error: function (err) {
                            deferred.reject(err);
                        }
                    });
                }, 0);

                return deferred.promise;
            }, function(err) {
                return $q.reject(err);
            });
        }

        chainCommands = chainCommands.then(function() {
            $scope.busy = false;
            if (callback) callback();
        }, function(err) {
            $scope.busy = false;
            RFHelper.showOkDialog(err.name, err.message);
        });
    };

    $scope.next = function () {
        if (!$scope.mout) {
            return
        }
        $scope.motorSpinning = true;
        $scope.toggleMotorSpinning($scope.currentMotor, function () {
            $scope.moutData['mout'+($scope.currentMotor+1)] = parseInt($scope.mout);
            console.log($scope.moutData)
            if ($scope.currentMotor > 1) {
                $scope.busy = true;
                var motors = [0, 1, 2, 3];
                var kArray = Object.keys($scope.moutData);
                var vArray = Object.values($scope.moutData);

                for (var i=0; i<motors.length; i++) {
                    if (vArray.indexOf(motors[i]) == -1) {
                        $scope.moutData[kArray[vArray.indexOf(null)]] = motors[i];
                    }
                }

                $scope.RFDump['set']['mout1'] = $scope.moutData["mout1"];
                $scope.RFDump['set']['mout2'] = $scope.moutData["mout2"];
                $scope.RFDump['set']['mout3'] = $scope.moutData["mout3"];
                $scope.RFDump['set']['mout4'] = $scope.moutData["mout4"];

                RFHelper.saveRFFWHIDRFDumpDialog({
                    'RFFWHID': $scope.RFFWHID,
                    'modifiedDump': $scope.RFDump,
                    success: function(RFFWHID) {
                        $scope.RFFWHID = RFFWHID;
                        $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
                        $scope.busy = false;
                        $state.go("rffwhid.rffwhid_wizard_fix_motor_direction_step_3")
                    },
                    error: function (err) {
                        $scope.busy = false;
                        if (err.message == 'Values are the same') {
                            $state.go("rffwhid.rffwhid_wizard_fix_motor_direction_step_3")
                        } else {
                            RFHelper.showOkDialog(err.name, err.message);
                        }
                    }
                });

            } else {
                $state.go("rffwhid.rffwhid_wizard_fix_motor_direction_step_2", {
                    currentMotor: $scope.currentMotor+1,
                    moutData: $scope.moutData
                });
            }
        });
    };

    $scope.back = function () {
        $scope.motorSpinning = true;
        $scope.toggleMotorSpinning($scope.currentMotor, function () {
            if ($scope.currentMotor > 0) {
                $scope.moutData['mout'+$scope.currentMotor] = null;

                $state.go("rffwhid.rffwhid_wizard_fix_motor_direction_step_2", {
                    currentMotor: $scope.currentMotor-1,
                    moutData: $scope.moutData
                });
            } else {
                $state.go("rffwhid.rffwhid_wizard_fix_motor_direction_step_1");
            }
        });
    };

    $scope.checkMoutKey = function (val) {
        for (var key in $scope.moutData) {
            if ($scope.moutData.hasOwnProperty(key)) {
                if ($scope.moutData[key] == val) {
                    return $scope.moutData[key];
                }
            }
        }
        return null;
    };

    if ($scope.currentMotor == 0) {
        $scope.resetMoutValues();
    } else {
        $scope.toggleMotorSpinning($scope.currentMotor);
    }


}).controller('rffwhidWizardFixMotorDirectionStep3Ctrl', function($scope, $timeout, $mdDialog, $state, $q, $translate, $stateParams, RFHelper) {
    $scope.busy = false;
    $scope.onewireReadData = {};

    $scope.onewireRead = function () {
        $scope.busy = true;
        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("GETTING_ESC_DATA");//"Getting ESC data...";

                var chainCommands = $q.when();

                chainCommands = chainCommands.then(function () {
                    var deferred = $q.defer();
                    $scope.RFFWHID.onewire({
                        commandArg: "read",
                        success: function (onewireReadData) {
                            $scope.onewireReadData = onewireReadData;
                            deferred.resolve();
                        },
                        error: function (err) {
                            deferred.reject(err);
                        }
                    });
                    return deferred.promise;
                }, function (err) {
                    return $q.reject(err);
                });

                chainCommands = chainCommands.then(function () {
                    var deferred = $q.defer();
                    $scope.RFFWHID.onewireStop({
                        success: function() {
                            RFHelper.showOkDialog($translate.instant("INFO"), $translate.instant("WAIT_UNTIL_ALL_TONES_FINISHED_THEN_CLICK_OK")).then(function () {
                                deferred.resolve();
                            });
                        },
                        error: function(err) {
                            deferred.reject(err);
                        }
                    });

                    return deferred.promise;
                }, function (err) {
                    return $q.reject(err);
                });

                chainCommands.then(function () {
                    $mdDialog.hide();
                    $scope.busy = false;
                }, function (err) {
                    $mdDialog.hide();

                    RFHelper.showConfirmDialog(err.name, err.message).then(function() {
                        $mdDialog.hide();
                        $scope.onewireRead();
                    }, function() {
                        $mdDialog.hide();
                        $state.go('rffwhid.setup');
                    });
                });
            }
        });
    };

    $scope.next = function () {
        $scope.busy = true;

        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("PROCESSING");

                var chainSetVar = $q.when();

                chainSetVar = chainSetVar.then(function () {
                    var deferred = $q.defer();
                    $scope.RFFWHID.onewire({
                        commandArg: "read",
                        success: function (onewireReadData) {
                            deferred.resolve();
                        },
                        error: function (err) {
                            deferred.reject(err);
                        }
                    });
                    return deferred.promise;
                }, function (err) {
                    return $q.reject(err);
                });

                for (var motor in $scope.onewireReadData) {
                    if ($scope.onewireReadData.hasOwnProperty(motor)) {
                        for (var key in $scope.onewireReadData[motor]) {
                            if ($scope.onewireReadData[motor].hasOwnProperty(key)) {
                                if (key == "direction") {
                                    (function(m, k) {
                                        chainSetVar = chainSetVar.then(function() {
                                            var deferred = $q.defer();
                                            $timeout(function(){
                                                dialogScope.additionalStatus = $translate.instant("rffwhid.rffwhid_wizard_fix_motor_direction_step_3.SET_VARIABLE_DIALOG_STATUS", {'motor': m, 'varName': k});

                                                $scope.RFFWHID.setonewireVar({
                                                    motor: m,
                                                    varName: k,
                                                    varVal: $scope.onewireReadData[m][k],
                                                    success: function() {
                                                        $timeout(function () {
                                                            dialogScope.additionalStatus = "";
                                                            deferred.resolve();
                                                        }, 0);
                                                    },
                                                    error: function(err) {
                                                        deferred.reject(err);
                                                    }
                                                });

                                            }, 0);

                                            return deferred.promise;
                                        }, function(err) {
                                            return $q.reject(err);
                                        });
                                    })(motor, key);
                                }
                            }
                        }
                    }
                }

                chainSetVar = chainSetVar.then(function(){
                    var deferred = $q.defer();
                    $timeout(function(){
                        dialogScope.status = $translate.instant("SAVING");
                        $scope.RFFWHID.onewireSave({
                            success: function() {
                                deferred.resolve();
                            },
                            error: function(err) {
                                deferred.reject(err);
                            }
                        });
                    }, 0);
                    return deferred.promise;
                }, function(err) {
                    return $q.reject(err);
                }).then(function() {
                    var deferred = $q.defer();
                    $scope.RFFWHID.onewireStop({
                        success: function() {
                            deferred.resolve();
                        },
                        error: function(err) {
                            deferred.reject(err);
                        }
                    });
                    return deferred.promise;
                }, function(err) {
                    return $q.reject(err);
                }).then(function() {
                    RFHelper.showOkDialog($translate.instant("INFO"), $translate.instant("WAIT_UNTIL_ALL_TONES_FINISHED_THEN_CLICK_OK")).then(function() {
                        $mdDialog.hide();
                        for (var i=0; i<4; i++) {
                            (function(index) {
                                chainSetVar = chainSetVar.then(function() {
                                    var deferred = $q.defer();
                                    $timeout(function () {
                                        $scope.RFFWHID.idle({
                                            index: index,
                                            success: function () {
                                                deferred.resolve();
                                            },
                                            error: function (err) {
                                                deferred.reject(err);
                                            }
                                        });
                                    }, 0);

                                    return deferred.promise;
                                }, function(err) {
                                    return $q.reject(err);
                                });
                            })(i);
                        }

                        chainSetVar = chainSetVar.then(function() {
                            RFHelper.showConfirmDialog(
                                $translate.instant("INFO"),
                                $translate.instant("rffwhid.rffwhid_wizard_fix_motor_direction_step_3.ARE_ALL_MOTORS_SPINNING_IN_RIGHT_DIRECTION_CONFIRM_MESSAGE"),
                                $translate.instant("NO"),
                                $translate.instant("YES")
                            ).then(function () {
                                $scope.RFFWHID.idlestop({
                                    success: function () {
                                        $scope.busy = false;
                                        $mdDialog.hide();
                                        $state.go('rffwhid.rffwhid_wizard_fix_motor_direction_step_4');
                                    },
                                    error: function (err) {
                                        $scope.busy = false;
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                            }, function () {
                                $scope.RFFWHID.idlestop({
                                    success: function () {
                                        $scope.onewireRead();
                                    },
                                    error: function (err) {
                                        $scope.busy = false;
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                            });
                        }, function (err) {
                            $scope.busy = false;
                            $mdDialog.hide();
                            RFHelper.showOkDialog(err.name, err.message);
                        });
                    });
                }, function (err) {
                    $scope.busy = false;
                    $mdDialog.hide();
                    RFHelper.showOkDialog(err.name, err.message);
                });
            }

        });

    };

    $scope.onewireRead();
}).controller('rffwhidWizardFixMotorDirectionStep4Ctrl', function($scope, $timeout, $mdDialog, $state) {

});