## How to install

##### Step 1:

Install Node.js :https://nodejs.org/  version **6.x.x** or higher

Check version: `node -v`

Node comes with npm installed so you should have a version of npm. 

Check version: `npm -v`

The version should be higher than **2.x.x**

##### Step 2:
 
Clone repository:

`git clone ssh://git@git.postingstats.com:8022/Arti3DPlayer/rf_configurator.git`


Then:

`cd rf_configurator`

And install dependencies:

`npm install`



## Translation tools:

##### Generate/Update translation files:

**WARN**: Never add keys to `.json` translation files manually.

Translation files located: `app/resources/translations`

For generate/update translations, do command:

```
grunt i18nextract
```

For clear empty strings:

```
grunt clearEmptyTranslationStrings
```

##### TranslateEditor

http://mrhieu.github.io/ngTranslateEditor/#/

This handy tool reads and writes JSON files which the standard loader are capable to read. It can be used for managing translations of small or medium sized translation tables.




## Build

**WARN**: Do not use GUI version.

Use only *web2exe* command line version to build package. web2exe folder contains win, mac-os, linux versions.

Command for build(mac):
```
.web2exe-mac {PATH_TO_PROJECT} --package-json {PATH_TO_PACKAGE.JSON} --nw-version 0.19.5 --main app/index.html --export-to mac-x64 --verbose
```

Add only `PATH_TO_PROJECT` and `PATH_TO_PACKAGE.JSON` file. Ignore other params.

All settings is located in `package.json` file:

`"webexe_settings": {}`

Example:

```
./web2exe/0.6.2b/Web2ExeMac-CMD/web2exe-mac ~/Jscode/rf_configurator --package-json ~/Jscode/rf_configurator/package.json --nw-version 0.19.5 --main app/index.html --export-to mac-x64 --verbose
```

```
./web2exe/0.6.2b/Web2ExeLinux-CMD/web2exe-linux /home/rf_configurator --package-json /home/rf_configurator/package.json --nw-version 0.19.5 --main app/index.html --export-to mac-x64 --verbose
```


## How to use material design icons

 - Go to 
https://material.io/icons/

 - Select needed icon
 
 - Use it like: `<i class="material-icons">assignment_late</i>`

## Versions

#### 0.228.0

- Added "Order motor" step to "Fix motor direction" wizard
- Fix bug when unable to save old value in ESC tab without reload

#### 0.223.0
- Increment version to 223 to match RC13

#### 0.197.0

- Added VTX PitMode Type wizard
- Added license page
- Fixing translations
- Small bug fixes
- Moved "Update firmware" title to top
- Added 16000 option for frequency
- Fixed ESC start up power saving
- Fixed issues caused by not working motors or other problems on ESC tab
- Update *de*,*fr*,*es* translations 
- Added OEM (beep) tone
- Added Digital Precision Mode

#### 0.196.0

- Added telemetry tab
- Fix radio data on setup tab
- Fix motor order in motor direction wizard
- Cosmetic fixes
- Fix translations
- Fix issue #72

#### 0.195.0

- Added DFU flashing mode
- Added de, es, fr, sk, zh-cn languages
- Fixed motor calibration labels
- Fixed small issues
- Added frequency options
- Added SmartAudio and OneShot options

#### 0.194.0

- Added localization
- Added "Medium Low" and "Medium High" timing options
- Added "Quick change PID level" button and Rates default values
- Fixed "Reset" button on PID Tuning page
- Fixed Bootloader flashing file upload, that could stuck when incorrect file has been uploaded.
- Fixed "Update Firmware" button
- Improved "Setup", "Detect" and "Radio" wizards.
- Fixed "ESC" tab when it fails sometimes.
