'use strict';

angular.module('rfApp.user_settings', [
    'ngRoute',
    'ngMaterial',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid.user_settings",
            url: "/user_settings",
            templateUrl: 'views/user_settings/user_settings.html',
            controller: 'UserSettingsCtrl'
        }).state({
            name: "rffwhid.license",
            url: "/license",
            templateUrl: 'views/user_settings/license.html'
        });
}]).controller('UserSettingsCtrl', function($scope, $mdDialog, RFHelper) {
    $scope.busy = false;

    $scope.save = function() {
        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                var fs = require('fs');
                var path = require('path');

                var file = 'user_settings.json';
                var filePath = path.join(nw.App.dataPath, file);

                $scope.busy = true;

                fs.writeFile(filePath, JSON.stringify($scope.USER_SETTINGS), function (err) {
                    $scope.busy = false;
                    $mdDialog.hide();
                    if (err) {
                        RFHelper.showOkDialog($translate.instant('rffwhid.user_settings.ATTEMPTING_TO_SAVE_SETTINGS'), err.message);
                    }
                });
            }
        });
    }

});