'use strict';

angular.module('rfApp.rffwhid_wizard_rx', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
        name: "rffwhid.rffwhid_wizard_rx_step_1",
        url: "/rffwhid_wizard_rx_step_1",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_rx_step1.html",
        controller: 'rffwhidWizardRxStep1Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_rx_step_2",
        url: "/rffwhid_wizard_rx_step_2",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_rx_step2.html"
    });
}]).controller('rffwhidWizardRxStep1Ctrl', function($scope, $timeout, $mdDialog, $state, $translate, RFHelper) {
    $scope.busy = false;

    $scope.next = function () {
        $scope.busy = true;

        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("rffwhid.rffwhid_wizard_rx_step_1.SCANNING_STATUS");
                dialogScope.buttons = {
                    'cancel': {
                        name: 'Cancel',
                        action: function () {
                            $scope.busy = false;
                        }
                    }
                };

                function getWizRxData() {
                    if (!$scope.$$destroyed && !dialogScope.$$destroyed && $scope.busy) {
                        $scope.RFFWHID.wizRx({
                            success: function (wizRxData) {
                                if (!$scope.$$destroyed && !dialogScope.$$destroyed && $scope.busy) {
                                    for (var i=0; i<wizRxData.length; i++) {
                                        if (wizRxData[i].match(/#me Scanning for RX/)) {
                                            dialogScope.additionalStatus = wizRxData[0].replace("#me ", "");
                                            $scope.updateWizRxDataTimeout = $timeout(function () {
                                                getWizRxData();
                                            }, 50);
                                            return
                                        } else if(wizRxData[0].match(/Found on Usart/)) {
                                            $mdDialog.hide();
                                            $scope.busy = false;
                                            $timeout.cancel($scope.updateWizRxDataTimeout);
                                            $state.go('rffwhid.rffwhid_wizard_rx_step_2');
                                            return
                                        } else if(wizRxData[0].match(/#me RX Not Found/)) {
                                            $mdDialog.hide();
                                            $scope.busy = false;
                                            $timeout.cancel($scope.updateWizRxDataTimeout);
                                            RFHelper.showOkDialog($translate.instant("ERROR"), $translate.instant("rffwhid.rffwhid_wizard_rx_step_1.RX_NOT_FOUND_MESSAGE"));
                                            return
                                        }
                                    }
                                }  else {
                                    $mdDialog.hide();
                                    $timeout.cancel($scope.updateWizRxDataTimeout);
                                }
                            },
                            error: function (err) {
                                $mdDialog.hide();
                                RFHelper.showOkDialog(err.name, err.message);
                            }
                        });
                    } else {
                        $mdDialog.hide();
                        $timeout.cancel($scope.updateWizRxDataTimeout);
                    }
                }

                $scope.updateWizRxDataTimeout = $timeout(function () {
                    getWizRxData();
                }, 50);
            }
        });
    };
});