'use strict';

angular.module('rfApp.rffwhid_setup', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'ya.nouislider',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid.setup",
            url: "/rffwhid_setup",
            templateUrl: "views/rffwhid_setup/rffwhid_setup.html",
            controller: 'rffwhidSetupCtrl'
        });
}]).controller('rffwhidSetupCtrl', function($scope, $timeout, $mdDialog, $translate, $stateParams, RFHelper) {
    $scope.busy = false;

    $scope.getModes = function() {
        var modes = angular.copy($scope.RFFWHID.RFDump.modes);
        for (var key in modes) {
            if (modes.hasOwnProperty(key)) {
                modes[key]['opts'] = {
                    start: [modes[key]['min'], modes[key]['max']],
                    range: {min: -100, max: 100},
                    tooltips: true,
                    connect: true,
                    pips: {
                        mode: 'steps',
                        density: 5,
                        filter: function (value, type){
                            return value == 100 || value == -100 ? 1 : 0;
                        }
                    },
                    step: 1
                }
            }
        }
        return modes;
    };

    $scope.modes = $scope.getModes();

    $scope.save = function(ev) {
        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                var modesKeys = Object.keys($scope.modes);
                var progressStep = 100/modesKeys.length-1; //count of modes + dump commands
                dialogScope.status = $translate.instant("SAVING");
                dialogScope.mode = 1;

                var currentKey = 0;
                $scope.busy = true;

                function setMode() {
                    if ($scope.$$destroyed && dialogScope.$$destroyed) {
                        return
                    }
                    if (currentKey < modesKeys.length) {
                        var modeKey = modesKeys[currentKey];
                        if ($scope.modes.hasOwnProperty(modeKey)) {
                            var mode = $scope.modes[modeKey];
                            $timeout(function(){
                                dialogScope.additionalStatus = $translate.instant("rffwhid.setup.SET_MODE_ADDITIONAL_STATUS", { 'mode': modeKey});
                                $scope.RFFWHID.setMode({
                                    mode: modeKey,
                                    channel: mode.channel,
                                    min: mode.opts.start[0],
                                    max: mode.opts.start[1],
                                    success: function () {
                                        if ($scope.$$destroyed && dialogScope.$$destroyed) {
                                            return
                                        }
                                        $timeout(function(){
                                            dialogScope.progress += progressStep;
                                            currentKey++;
                                            setMode();
                                        }, 0);
                                    },
                                    error: function (err) {
                                        if ($scope.$$destroyed && dialogScope.$$destroyed) {
                                            return
                                        }
                                        $mdDialog.hide();
                                        $scope.busy = false;
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                            }, 0);
                        }
                    } else {
                        $timeout(function(){
                            dialogScope.additionalStatus = $translate.instant("rffwhid.setup.SAVE_MODES_ADDITIONAL_STATUS");
                            $scope.RFFWHID.save({
                                success: function() {
                                    if ($scope.$$destroyed && dialogScope.$$destroyed) {
                                        return
                                    }
                                    $timeout(function(){
                                        dialogScope.additionalStatus = $translate.instant("GETTING_NEW_DATA");
                                        dialogScope.progress += progressStep;
                                        $scope.RFFWHID.dump({
                                            populateDump: true,
                                            success: function () {
                                                if ($scope.$$destroyed && dialogScope.$$destroyed) {
                                                    return
                                                }
                                                $timeout(function(){
                                                    dialogScope.progress += progressStep;
                                                    $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
                                                    $mdDialog.hide();
                                                    $scope.modes = $scope.getModes();
                                                    $scope.busy = false;
                                                }, 0);
                                            },
                                            error: function (err) {
                                                if ($scope.$$destroyed && dialogScope.$$destroyed) {
                                                    return
                                                }
                                                $mdDialog.hide();
                                                $scope.busy = false;
                                                RFHelper.showOkDialog(err.name, err.message);
                                            }
                                        });
                                    }, 0);
                                },
                                error: function(err) {
                                    if ($scope.$$destroyed && dialogScope.$$destroyed) {
                                        return
                                    }
                                    $mdDialog.hide();
                                    $scope.busy = false;
                                    RFHelper.showOkDialog(err.name, err.message);
                                }
                            });
                        }, 0);

                    }
                }

                //Wait for possible not finished received functions
                $timeout(function(){
                    setMode();
                }, 50);
            }
        });


    };

    $scope.reset = function(ev) {
        RFHelper.showConfirmDialog(
            $translate.instant("rffwhid.setup.RESET_CHANGES_CONFIRM_DIALOG_TITLE"),
            $translate.instant("rffwhid.setup.RESET_CHANGES_CONFIRM_DIALOG_CONTENT")
        ).then(function() {
            $scope.modes = $scope.getModes();
        });
    };


    $scope.getRCdata = function() {
        if ($scope.busy && !$scope.$$destroyed) {
            $scope.updateRCdataTimeout = $timeout(function () {
                $scope.getRCdata();
            }, 50);
        } else if (!$scope.$$destroyed) {

            $scope.RFFWHID.rcdata({
                success: function (rcdata) {
                    for (var key in $scope.modes) {
                        if ($scope.modes.hasOwnProperty(key)) {
                            if (rcdata.hasOwnProperty($scope.modes[key]['channel'])) {
                                var rc = rcdata[$scope.modes[key]['channel']];
                                var sliderEl = document.getElementById(key+"-slider");
                                if (sliderEl) {
                                    var sliderScope = angular.element(sliderEl).isolateScope();

                                    if (sliderScope) {
                                        var pips = sliderEl.getElementsByClassName("noUi-marker");
                                        for (var i=0; i<pips.length; i++) {
                                            pips[i].classList.remove("noUI-highlight-marker");
                                            if (-100+i == parseInt(rc.val/10)) {
                                                pips[i].classList.add("noUI-highlight-marker");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if (!$scope.$$destroyed) {
                        $scope.updateRCdataTimeout = $timeout(function () {
                            $scope.getRCdata();
                        }, 50);
                    }
                },
                error: function (err) {
                    console.log(err);
                    $scope.updateRCdataTimeout = $timeout(function () {
                        $scope.getRCdata();
                    }, 50);
                }
            });
        }
    };

    $scope.showRCdataModal = function () {
        $scope.busy = true;
        $mdDialog.show({
            controller: 'showRCDataDialogCtrl',
            templateUrl: 'views/rffwhid_setup/rcdataDialog.tmpl.html',
            clickOutsideToClose: true
        }).finally(function() {
            $scope.busy = false;
        });
    };

    $scope.updateRCdataTimeout = $timeout(function () {
        $scope.getRCdata();
    }, 50);


    $scope.$on("$destroy", function(){
       $timeout.cancel($scope.updateRCdataTimeout);
    });

}).controller('showRCDataDialogCtrl', function($scope, $mdDialog, $timeout, $rootScope) {
    $scope.rcdata = null;
    $scope.busy = false;

    $scope.getRCdata = function() {
        if ($scope.busy && !$scope.$$destroyed) {
            $scope.updateRCdataTimeout = $timeout(function () {
                $scope.getRCdata();
            }, 50);
        } else if (!$scope.$$destroyed) {

            $rootScope.RFFWHID.rcdata({
                success: function (rcdata) {
                    $scope.rcdata = rcdata;

                    if (!$scope.$$destroyed) {
                        $scope.updateRCdataTimeout = $timeout(function () {
                            $scope.getRCdata();
                        }, 50);
                    }
                },
                error: function (err) {
                    console.log(err);
                }
            });
        }
    };

    $scope.updateRCdataTimeout = $timeout(function(){
        $scope.getRCdata();
    }, 50);

    $scope.$on("$destroy", function(){
        $timeout.cancel($scope.updateRCdataTimeout);
    });

    $scope.closeDialog = function () {
        $mdDialog.hide();
    }
});