'use strict';

angular.module('rfApp.rffwhid_logging', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid.logging",
            url: "/logging",
            templateUrl: "views/rffwhid_logging/rffwhid_logging.html",
            controller: 'rffwhidLoggingCtrl'
        });
}]).controller('rffwhidLoggingCtrl', function($scope, $rootScope, $mdDialog, $timeout, $translate, RFHelper) {

    $scope.formatFlash = function() {
        $mdDialog.show({
            controller: 'confirmDialogCtrl',
            templateUrl: 'tmpl/confirmDialog.tmpl.html',
            locals: {
                title: $translate.instant("rffwhid.logging.FORMAT_FLASH_CONFIRM_DIALOG_TITLE"),
                textContent: $translate.instant("rffwhid.logging.FORMAT_FLASH_CONFIRM_DIALOG_CONTENT")
            },
            buttons: {
                "cancel": {
                    "name": $translate.instant("CANCEL"),
                    "action": function () {
                        $mdDialog.hide();
                    }
                },
                "confirm": {
                    "name": $translate.instant("CONFIRM"),
                    "action": function () {
                        $mdDialog.hide();
                        $mdDialog.show({
                            controller: 'loadingDialogCtrl',
                            templateUrl: 'tmpl/loadingDialog.tmpl.html',
                            onComplete: function (dialogScope, element) {
                                dialogScope.status = $translate.instant("rffwhid.logging.FORMAT_FLASH_STATUS_FORMATTING");
                                dialogScope.additionalStatus = $translate.instant("rffwhid.logging.FORMAT_FLASH_ADDITIONAL_STATUS_FORMATTING");
                                $scope.RFFWHID.eraseAllFlash({
                                    success: function () {
                                        $timeout(function () {
                                            dialogScope.status = $translate.instant("GETTING_NEW_DATA");
                                            dialogScope.additionalStatus = "";

                                            $scope.RFFWHID.dump({
                                                populateDump: true,
                                                success: function () {
                                                    $mdDialog.hide();
                                                },
                                                error: function (err) {
                                                    $mdDialog.hide();
                                                    RFHelper.showOkDialog(err.name, err.message);
                                                }
                                            });
                                        }, 0);
                                    },
                                    error: function (err) {
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                            }
                        });
                    }
                }
            }

        });
    };

    $scope.eraseFlash = function () {
        $mdDialog.show({
            controller: 'confirmDialogCtrl',
            templateUrl: 'tmpl/confirmDialog.tmpl.html',
            locals: {
                title: $translate.instant("rffwhid.logging.ERASE_FLASH_CONFIRM_DIALOG_TITLE"),
                textContent: $translate.instant("rffwhid.logging.ERASE_FLASH_CONFIRM_DIALOG_CONTENT")
            },
            buttons: {
                "cancel": {
                    "name": $translate.instant("CANCEL"),
                    "action": function () {
                        $mdDialog.hide();
                    }
                },
                "confirm": {
                    "name": $translate.instant("CONFIRM"),
                    "action": function () {
                        $mdDialog.hide();
                        $mdDialog.show({
                            controller: 'loadingDialogCtrl',
                            templateUrl: 'tmpl/loadingDialog.tmpl.html',
                            onComplete: function (dialogScope, element) {
                                dialogScope.status = $translate.instant("rffwhid.logging.ERASE_FLASH_STATUS_ERASING");
                                dialogScope.additionalStatus = $translate.instant("rffwhid.logging.ERASE_FLASH_ADDITIONAL_STATUS_ERASING");

                                $scope.RFFWHID.eraseFlash({
                                    success: function () {
                                        $timeout(function(){
                                            dialogScope.status = $translate.instant("GETTING_NEW_DATA");
                                            dialogScope.additionalStatus = "";

                                            $scope.RFFWHID.dump({
                                                populateDump: true,
                                                success: function () {
                                                    $mdDialog.hide();
                                                },
                                                error: function (err) {
                                                    $mdDialog.hide();
                                                    RFHelper.showOkDialog(err.name, err.message);
                                                }
                                            });
                                        }, 0);
                                    },
                                    error: function (err) {
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                            }
                        });
                    }
                }
            }
        });
    };

    $scope.loadLogFile = function () {
        chrome.fileSystem.chooseEntry({
            type: 'openFile',
            accepts: [{
                //description: 'Raw Binary (.bin)',
                extensions: ['txt']
            }]
        }, function (fileEntry) {
            if (chrome.runtime.lastError) {
                $timeout(function () {
                    $scope.busy = false;
                });

                console.error(chrome.runtime.lastError.message);
                return;
            }

            chrome.fileSystem.getDisplayPath(fileEntry, function (path) {
                console.log('Loading file from: ' + path);

                fileEntry.file(function (file) {
                    var reader = new FileReader();

                    reader.onloadend = function (e) {
                        var bytes = e.target.result;

                    };

                    reader.readAsArrayBuffer(file);
                });



            });
        });
    };

    $scope.downloadFlightLog = function() {
        var date = new Date(), filename = 'flightlog_' + date.getFullYear() + '-'  + date.getMonth() + 1 + '-'
            + date.getDate() + '_' + date.getHours() + date.getMinutes() + date.getSeconds();


        if (!$scope.RFFWHID.RFDump['fl']) {
            RFHelper.showOkDialog($translate.instant("ERROR"), "fl key doesn\'t exist.");
            return
        }

        var flsize = $scope.RFFWHID.RFDump['fl']['size'];
        var fltotal = $scope.RFFWHID.RFDump['fl']['total'];

        if (!flsize || !fltotal) {
            RFHelper.showOkDialog($translate.instant("ERROR"), "flsize or fltotal is null.");
            return
        }

        if (flsize < 1) {
            RFHelper.showOkDialog($translate.instant("INFO"), $translate.instant("rffwhid.logging.FLIGHT_LOG_IS_EMPTY"));
            return
        }

        chrome.fileSystem.chooseEntry({
            type: 'saveFile',
            suggestedName: filename,
            accepts: [{
                extensions: ['txt']
            }]
        }, function(fileEntry) {
            if (chrome.runtime.lastError) {
                RFHelper.showOkDialog(chrome.runtime.lastError.message);
                return;
            }

            // echo/console log path specified
            chrome.fileSystem.getDisplayPath(fileEntry, function(path) {
                //console.log('Dataflash dump file path: ' + path);
            });

            fileEntry.createWriter(function (fileWriter) {
                fileWriter.onerror = function (err) {
                    console.error(err);
                    // stop logging if the procedure was/is still running
                };

                var bytesReceived = 0;
                var flightLogBuffer = [];
                var cancelled = false;
                $mdDialog.show({
                    controller: 'loadingDialogCtrl',
                    templateUrl: 'tmpl/loadingDialog.tmpl.html',
                    onComplete: function (dialogScope, element) {
                        dialogScope.status = $translate.instant("rffwhid.logging.DOWNLOADING_STATUS");
                        dialogScope.mode = 1;
                        dialogScope.additionalStatus = bytesReceived+"/"+flsize;
                        dialogScope.buttons = {
                            'cancel': {
                                name: $translate.instant("CANCEL"),
                                action: function () {
                                    cancelled = true;
                                    $scope.RFFWHID.busy = false;
                                    $timeout.cancel(self.busyTimeout);
                                }
                            }
                        };

                        function handleFlightLog(command) {
                            var data = $scope.RFFWHID.hidStrToBytes(command);

                            if ($scope.RFFWHID.busy) {
                                console.log("Board is busy. Waiting");
                                $scope.RFFWHID.busyTimeout = $timeout(function () {
                                    handleFlightLog(command);
                                }, $scope.RFFWHID.busyDelay);
                                return
                            }

                            $scope.RFFWHID.busy = true;

                            $scope.RFFWHID.sendAndReceive({
                                data: data,
                                success: function (reportId, data) {
                                    $scope.RFFWHID.busy = false;
                                    $scope.RFFWHID.busyTimeout = null;

                                    if (cancelled) {
                                        fileEntry.remove(function() {
                                            console.log('File removed.');
                                        }, function() {
                                            console.log('File remove error.');
                                        });
                                        $mdDialog.hide();
                                        return
                                    }
                                    $timeout(function(){
                                        var responseStr = $scope.RFFWHID.receivedDataToStr(data);

                                        if (responseStr.indexOf("STARTLOG") !== -1) {
                                            flightLogBuffer.push("H Product:Blackbox flight data recorder by Nicholas Sherlock\n\
                                                                    H Data version:2\n\
                                                                    H I interval:1\n\
                                                                    H Field I name:loopIteration,time,axisP[2],axisI[2],axisD[2],axisP[0],axisI[0],axisD[0],axisP[1],axisI[1],axisD[1],rcCommand[2],rcCommand[0],rcCommand[1],rcCommand[3],debug[2],debug[0],debug[1],ugyroADC[2],ugyroADC[0],ugyroADC[1],accSmooth[2],accSmooth[0],accSmooth[1],motor[0],motor[1],motor[2],motor[3]\n\
                                                                    H Field I signed:0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1\n\
                                                                    H Field I predictor:0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n\
                                                                    H Field I encoding:1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n\
                                                                    H Field P predictor:6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1\n\
                                                                    H Field P encoding:9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n\
                                                                    H Field S name:flightModeFlags,stateFlags,failsafePhase,rxSignalReceived,rxFlightChannelsValid\n\
                                                                    H Field S signed:0,0,0,0,0\n\
                                                                    H Field S predictor:0,0,0,0,0\n\
                                                                    H Field S encoding:1,1,7,7,7\n\
                                                                    H Firmware type:Raceflight\n\
                                                                    H Firmware revision:One\n\
                                                                    H Firmware date:Oct 31 2015 22:44:00\n\
                                                                    P interval:1/1\n\
                                                                    H rcRate:100\n\
                                                                    H minthrottle:1100\n\
                                                                    H maxthrottle:2000\n\
                                                                    H gyro.scale:0x41600000\n\
                                                                    H acc_1G:1\n");
                                        } else {
                                            flightLogBuffer.push(data);
                                        }

                                        bytesReceived += 63;
                                        dialogScope.progress = bytesReceived*100/flsize;
                                        dialogScope.additionalStatus = bytesReceived+"/"+flsize;
                                        if (bytesReceived <= flsize) {
                                            handleFlightLog("readflash "+bytesReceived);
                                        } else {
                                            fileWriter.write(new Blob(flightLogBuffer));
                                            flightLogBuffer = [];
                                            $mdDialog.hide();
                                        }
                                    }, 0);
                                },
                                error: function (err) {
                                    RFHelper.showOkDialog(err.name, err.message);
                                }
                            });
                        }

                        handleFlightLog("readflash "+bytesReceived);
                    }
                });
            }, function (err) {
                // File is not readable or does not exist!
                console.error(err);
            });
        });
    };
});