'use strict';

angular.module('rfApp.rffwhid_esc', [
    'ngRoute',
    'ngMaterial',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid.esc",
            url: "/rffwhid_esc",
            templateUrl: 'views/rffwhid_esc/rffwhid_esc.html',
            controller: 'rffwhidESCCtrl'
        })
}]).controller('rffwhidESCCtrl', function($scope, $timeout, $mdDialog, $q, $translate, RFHelper) {
    $scope.busy = true;
    $scope.onewireReadData = null;
    $scope.onewireReadDataDummy = null;

    $scope.timing = null;
    $scope.timing_names = [
        {'val': 'low', 'name': $translate.instant("rffwhid.esc.TIMING_NAME_LOW_OPTION")},
        {'val': 'medlow', 'name': $translate.instant("rffwhid.esc.TIMING_NAME_MEDIUM_LOW_OPTION")},
        {'val': 'medium', 'name': $translate.instant("rffwhid.esc.TIMING_NAME_MEDIUM_OPTION")},
        {'val': 'medhigh', 'name': $translate.instant("rffwhid.esc.TIMING_NAME_MEDIUM_HIGH_OPTION")},
        {'val': 'high', 'name': $translate.instant("rffwhid.esc.TIMING_NAME_HIGH_OPTION")}
    ];

    $scope.$watch('timing', function(newValue, oldValue) {
        if (newValue !== oldValue) {
            $scope.onewireReadDataDummy.m0.timing = newValue;
            $scope.onewireReadDataDummy.m1.timing = newValue;
            $scope.onewireReadDataDummy.m2.timing = newValue;
            $scope.onewireReadDataDummy.m3.timing = newValue;
        }
    });


    $scope.beepstrength = null;
    $scope.beepstrength_names = [
        {'val': 1, 'name': 'Stealth Mode - Silent Tone'},
        {'val': 90, 'name': 'OEM Beep Tones'},
        {'val': 91, 'name': 'Imperial March Tone'},
        {'val': 92, 'name': 'Crazy Start Tone'},
        {'val': 93, 'name': 'Game of Thrones Tone'},
        {'val': 94, 'name': 'HG startup Tone'}
    ];

    $scope.$watch('beepstrength', function(newValue, oldValue) {
        if (newValue !== oldValue) {
            $scope.onewireReadDataDummy.m0.beepstrength = newValue;
            $scope.onewireReadDataDummy.m1.beepstrength = newValue;
            $scope.onewireReadDataDummy.m2.beepstrength = newValue;
            $scope.onewireReadDataDummy.m3.beepstrength = newValue;
        }
    });

    $scope.startuppower = null;
    $scope.startuppower_names = [
        {'val': "0.031", 'name': '0.031'},
        {'val': "0.047", 'name': '0.047'},
        {'val': "0.063", 'name': '0.063'},
        {'val': "0.094", 'name': '0.094'},
        {'val': "0.125", 'name': '0.125'},
        {'val': "0.188", 'name': '0.188'},
        {'val': "0.25", 'name': '0.25'},
        {'val': "0.38", 'name': '0.38'},
        {'val': "0.50", 'name': '0.50'},
        {'val': "0.75", 'name': '0.75'},
        {'val': "1.00", 'name': '1.00'},
        {'val': "1.25", 'name': '1.25'}
    ];

    $scope.$watch('startuppower', function(newValue, oldValue) {
        if (newValue !== oldValue) {
            $scope.onewireReadDataDummy.m0.startuppower = newValue;
            $scope.onewireReadDataDummy.m1.startuppower = newValue;
            $scope.onewireReadDataDummy.m2.startuppower = newValue;
            $scope.onewireReadDataDummy.m3.startuppower = newValue;
        }
    });

    $scope.readData = function() {
        $scope.busy = true;

        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("GETTING_ESC_DATA");

                var chainCommands = $q.when();

                chainCommands = chainCommands.then(function () {
                    var deferred = $q.defer();
                    $scope.RFFWHID.onewire({
                        commandArg: "read",
                        success: function (onewireReadData) {
                            $scope.onewireReadData = onewireReadData;
                            $scope.onewireReadDataDummy = angular.copy($scope.onewireReadData);

                            for (var i=0; i<4; i++) {
                                if (!$scope.onewireReadDataDummy.hasOwnProperty("m"+i)) {
                                    deferred.reject(
                                        new Error(
                                            $translate.instant("rffwhid.esc.MOTOR_NOT_FOUND", {'motor': i})
                                        )
                                    );
                                    return
                                }
                            }

                            // Take one random motor to get info from it
                            $scope.beepstrength = $scope.onewireReadDataDummy.m1.beepstrength;
                            $scope.timing = $scope.onewireReadDataDummy.m1.timing;
                            $scope.startuppower = $scope.onewireReadDataDummy.m1.startuppower;

                            deferred.resolve();
                        },
                        error: function (err) {
                            deferred.reject(err);
                        }
                    });
                    return deferred.promise;
                }, function (err) {
                    return $q.reject(err);
                });

                chainCommands = chainCommands.then(function () {
                    var deferred = $q.defer();
                    $scope.RFFWHID.onewireStop({
                        success: function() {
                            RFHelper.showOkDialog($translate.instant("INFO"), $translate.instant("WAIT_UNTIL_ALL_TONES_FINISHED_THEN_CLICK_OK")).then(function () {
                                deferred.resolve();
                            });
                        },
                        error: function(err) {
                            deferred.reject(err);
                        }
                    });
                    return deferred.promise;
                }, function (err) {
                    return $q.reject(err);
                });

                chainCommands.then(function () {
                    $mdDialog.hide();
                    $scope.busy = false;
                }, function (err) {
                    $mdDialog.hide();

                    RFHelper.showConfirmDialog(err.name, err.message, $translate.instant("CANCEL"), $translate.instant("TRY_AGAIN")).then(function() {
                        $mdDialog.hide();
                        $scope.readData();
                    }, function() {
                        $mdDialog.hide();
                        $scope.onewireReadData = null;
                        $scope.onewireReadDataDummy = null;
                    });
                });
            }
        });
    };

    $scope.save = function(ev) {
        if(!$scope.escForm.$valid) {
            return
        }

        if (!DeepDiff.diff($scope.onewireReadData, $scope.onewireReadDataDummy)) {
            return
        }

        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("PROCESSING");

                var chainSetVar = $q.when();

                chainSetVar = chainSetVar.then(function () {
                    var deferred = $q.defer();
                    $scope.RFFWHID.onewire({
                        commandArg: "read",
                        success: function (onewireReadData) {
                            deferred.resolve();
                        },
                        error: function (err) {
                            deferred.reject(err);
                        }
                    });
                    return deferred.promise;
                }, function (err) {
                    return $q.reject(err);
                });


                DeepDiff.observableDiff($scope.onewireReadData, $scope.onewireReadDataDummy, function (obj) {
                    var m = obj.path[0];
                    var k = obj.path[1];
                    chainSetVar = chainSetVar.then(function () {
                        var deferred = $q.defer();
                        $timeout(function () {
                            dialogScope.additionalStatus = $translate.instant("rffwhid.esc.SET_VARIABLE_DIALOG_STATUS", {
                                'motor': m,
                                'varName': k
                            });
                            //console.log("Set variable: " + m + ": " + k + "=" + $scope.onewireReadDataDummy[m][k]);

                            $scope.RFFWHID.setonewireVar({
                                motor: m,
                                varName: k,
                                varVal: $scope.onewireReadDataDummy[m][k],
                                success: function () {
                                    $timeout(function () {
                                        dialogScope.additionalStatus = "";
                                        deferred.resolve();
                                    }, 0);
                                },
                                error: function (err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function (err) {
                        return $q.reject(err);
                    });
                });


                chainSetVar = chainSetVar.then(function(){
                    var deferred = $q.defer();
                    $timeout(function(){
                        dialogScope.status = $translate.instant("SAVING");
                        $scope.RFFWHID.onewireSave({
                            success: function() {
                                deferred.resolve();
                            },
                            error: function(err) {
                                deferred.reject(err);
                            }
                        });
                    }, 0);
                    return deferred.promise;
                }, function(err) {
                    return $q.reject(err);
                }).then(function() {
                    var deferred = $q.defer();
                    $scope.RFFWHID.onewireStop({
                        success: function() {
                            deferred.resolve();
                        },
                        error: function(err) {
                            deferred.reject(err);
                        }
                    });
                    return deferred.promise;
                }, function(err) {
                    return $q.reject(err);
                }).then(function(){
                    RFHelper.showOkDialog($translate.instant("INFO"), $translate.instant("WAIT_UNTIL_ALL_TONES_FINISHED_THEN_CLICK_OK")).then(function () {
                        $scope.busy = false;
                        $mdDialog.hide();
                        // Perform $scope.readData(); takes a lot of time, so set our new values from dummy to original
                        $scope.onewireReadData = angular.copy($scope.onewireReadDataDummy);
                    });
                }, function (err) {
                    $mdDialog.hide();
                    RFHelper.showOkDialog(err.name, err.message);
                    $scope.busy = false;
                });
            }
        });

    };


    $scope.readData();

});