'use strict';

angular.module('rfApp.rffwhid_wizard_bind_spektrum', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
        name: "rffwhid.rffwhid_wizard_bind_spektrum_step_1",
        url: "/rffwhid_wizard_bind_spektrum_step_1",
        templateUrl: "views/rffwhid_configuration/rffwhid_wizard_bind_spektrum_step1.html",
        controller: 'rffwhidBindSpektrumWizardStep1Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_bind_spektrum_step_2",
        url: "/rffwhid_wizard_bind_spektrum_step_2",
        templateUrl: "views/rffwhid_configuration/rffwhid_wizard_bind_spektrum_step2.html"
    });
}]).controller('rffwhidBindSpektrumWizardStep1Ctrl', function($scope, $state) {
    $scope.bindType = "";

    $scope.next = function (ev) {
        var index;
        switch ($scope.bindType) {
            case "bind9":
                index = 9;
                break;
            case "bind5":
                index = 5;
                break;
            case "bind3":
                index = 3;
                break;
            default:
                return;
        }

        $scope.RFFWHID.bind({
            index: index,
            success: function () {
                $state.go('rffwhid.rffwhid_wizard_bind_spektrum_step_2');
            },
            error: function (err) {
                RFHelper.showOkDialog(err.name, err.message);
            }
        });

    };
});