'use strict';

angular.module('rfApp.rffwhid_configuration', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid.configuration",
            url: "/rffwhid_configuration",
            templateUrl: "views/rffwhid_configuration/rffwhid_configuration.html",
            controller: 'rffwhidConfigurationCtrl'
        });
}]).controller('rffwhidConfigurationCtrl', function($scope, $timeout, $mdDialog, $q, $translate, RFHelper) {
    $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);

    $scope.led_mode_names = [
        {'val': 0, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.OFF_OPTION')},
        {'val': 1, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.ON_OPTION')},
        {'val': 2, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.DISCO_FAST_OPTION')},
        {'val': 3, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.DISCO_SLOW_OPTION')},
        {'val': 4, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.PARTY_FAST_OPTION')},
        {'val': 5, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.PARTY_SLOW_OPTION')},
        {'val': 6, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.GYRO_MOTION_OPTION')},
        {'val': 7, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.COLOR_PULSE_OPTION')},
        {'val': 8, 'name':  $translate.instant('rffwhid.configuration.LED_MODE_NAME.MULTI_DISCO_FAST_OPTION')},
        {'val': 9, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.MULTI_DISCO_SLOW_OPTION')},
        {'val': 10, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.MULTI_PARTY_FAST_OPTION')},
        {'val': 11, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.MULTI_PARTY_SLOW_OPTION')},
        {'val': 12, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.KNIGHT_RIDER_OPTION')},
        {'val': 13, 'name': $translate.instant('rffwhid.configuration.LED_MODE_NAME.BATTERY_LEVEL_OPTION')}
    ];

    $scope.rx_protocol_names = [
        {'val': 1, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.SPEKTRUM_RX_PIN_OPTION')},
        {'val': 2, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.SPEKTRUM_TX_PIN_OPTION')},
        {'val': 3, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.SBUS_RX_PIN_OPTION')},
        {'val': 4, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.SBUS_TX_PIN_OPTION')},
        {'val': 5, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.SUMD_RX_PIN_OPTION')},
        {'val': 6, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.SUMD_TX_PIN_OPTION')},
        {'val': 7, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.IBUS_RX_PIN_OPTION')},
        {'val': 8, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.IBUS_TX_PIN_OPTION')},
        {'val': 9, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.CPPM_RX_PIN_OPTION')},
        {'val': 10, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.CPPM_TX_PIN_OPTION')},
        {'val': 11, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.DSM2_RX_PIN_OPTION')},
        {'val': 12, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.DSM2_TX_PIN_OPTION')}
    ];

    $scope.rx_usart_names = [

        {'val': 2, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.UART_3_OPTION')},
        {'val': 4, 'name': $translate.instant('rffwhid.configuration.RX_PROTOCOL_NAMES.UART_5_OPTION')}
    ];

    $scope.esc_frequency_names = [
        {'val': 2000, 'name': '2000'},
        {'val': 8000, 'name': '8000'},
        {'val': 16000, 'name': '16000'},
        {'val': 32000, 'name': '32000'}
    ];

    $scope.arm_method_names = {
        '0': $translate.instant('rffwhid.configuration.SINGLE_ARM_OPTION'),
        '1': $translate.instant('rffwhid.configuration.DOUBLE_ARM_OPTION')
    };

    $scope.esc_protocol_names = [
        {'val': 0, 'name': $translate.instant('rffwhid.configuration.ESC_PROTOCOL_NAMES.MULTISHOT_OPTION')},
        {'val': 1, 'name': $translate.instant('rffwhid.configuration.ESC_PROTOCOL_NAMES.ONESHOT_OPTION')}
    ];

    $scope.telem_smartaudio_names = [
        {'val': 0, 'name': $translate.instant('rffwhid.configuration.TELEM_SMARTAUDIO_NAMES.SMARTAUDIO_DISABLED_OPTION')},
        {'val': 24, 'name': $translate.instant('rffwhid.configuration.TELEM_SMARTAUDIO_NAMES.4TX_OPTION')}
    ];

    $scope.enable_digital_precision_mode = function () {
        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                var commandChain = $q.when();

                var progressStep = 50;
                dialogScope.mode = 1;

                commandChain = commandChain.then(function(){
                    var deferred = $q.defer();
                    $timeout(function() {
                        dialogScope.additionalStatus = $translate.instant("rffwhid.configuration.ENABLE_DIGITAL_PRECISION_MODE_ADDITIONAL_STATUS");
                        $scope.RFFWHID.dpmode({
                            success: function() {
                                $timeout(function() {
                                    dialogScope.progress += progressStep;
                                    deferred.resolve();
                                }, 0);
                            },
                            error: function(err) {
                                deferred.reject(err);
                            }
                        });
                    }, 0);
                    return deferred.promise;
                }, function(err) {
                    return $q.reject(err);
                });

                commandChain = commandChain.then(function(){
                    var deferred = $q.defer();
                    $timeout(function() {
                        dialogScope.additionalStatus = $translate.instant("GETTING_NEW_DATA");
                        dialogScope.progress += progressStep;
                        $scope.RFFWHID.dump({
                            populateDump: true,
                            success: function () {
                                $timeout(function() {
                                    dialogScope.progress += progressStep;
                                    deferred.resolve();
                                },0);
                            },
                            error: function (err) {
                                deferred.reject(err);
                            }
                        });
                    }, 0);
                    return deferred.promise;
                }, function(err) {
                    return $q.reject(err);
                });

                commandChain.then(function(){
                    $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
                    $mdDialog.hide();
                }, function(err) {
                    $mdDialog.hide();
                    RFHelper.showOkDialog(err.name, err.message);
                });

            }
        });
    };

    $scope.save = function(ev) {
        if(!$scope.configurationForm.$valid) {
            return
        }

        var changedKeys = [];

        // @r2sk When the ESC protocol is set to DSHOT 600, can you make sure the ESC frequency gets set to 16000 if it’s at 32000?
        if ($scope.RFDump.set.hasOwnProperty("esc_protocol") &&
            $scope.RFDump.set.hasOwnProperty("esc_frequency") &&
            $scope.RFDump.set.esc_protocol == 7 &&
            $scope.RFDump.set.esc_frequency == 32000) {
            $scope.RFDump.set.esc_frequency = 16000
        }

        for (var inputVal in $scope.RFDump['set']) {
            if ($scope.RFDump['set'].hasOwnProperty(inputVal) &&
                $scope.RFFWHID.RFDump['set'].hasOwnProperty(inputVal) &&
                $scope.RFDump['set'][inputVal] != $scope.RFFWHID.RFDump['set'][inputVal]) {
                changedKeys.push(inputVal);
            }
        }

        if (changedKeys.length) {
            $mdDialog.show({
                controller: 'loadingDialogCtrl',
                templateUrl: 'tmpl/loadingDialog.tmpl.html',
                onComplete: function (dialogScope, element) {
                    var progressStep = 100/changedKeys.length-2; //count of set + save + dump commands
                    dialogScope.status = $translate.instant("SAVING");
                    dialogScope.mode = 1;

                    var setVarChain = $q.when();

                    for (var i=0; i<changedKeys.length; i++) {
                        (function(index) {
                            setVarChain = setVarChain.then(function() {
                                var deferred = $q.defer();
                                $timeout(function () {
                                    dialogScope.additionalStatus = "Set variable: " + changedKeys[index];

                                    $scope.RFFWHID.setVar({
                                        index: index,
                                        varName: changedKeys[index],
                                        varValue: $scope.RFDump['set'][changedKeys[index]],
                                        success: function () {
                                            $timeout(function() {
                                                dialogScope.progress += progressStep;
                                                deferred.resolve();
                                            }, 0);
                                        },
                                        error: function (err) {
                                            deferred.reject(err);
                                        }
                                    });
                                }, 0);

                                return deferred.promise;
                            }, function(err) {
                                return $q.reject(err);
                            });
                        })(i);
                    }

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("SAVING_VARIABLES");
                            $scope.RFFWHID.save({
                                success: function() {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    }, 0);
                                },
                                error: function(err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("GETTING_NEW_DATA");
                            dialogScope.progress += progressStep;
                            $scope.RFFWHID.dump({
                                populateDump: true,
                                success: function () {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    },0);
                                },
                                error: function (err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        $mdDialog.hide();
                        $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
                    }, function(err) {
                        $mdDialog.hide();
                        RFHelper.showOkDialog(err.name, err.message);
                    });
                }
            });
        }
    };

});