'use strict';

angular.module('rfApp.rffwhid_wizard_1wire_auto', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
        name: "rffwhid.rffwhid_wizard_1wire_auto_step_1",
        url: "/rffwhid_wizard_1wire_auto_step_1",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_1wire_auto_step1.html",
        controller: 'rffwhidWizard1WireAutoStep1Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_1wire_auto_step_2",
        url: "/rffwhid_wizard_1wire_auto_step_2",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_1wire_auto_step2.html",
        controller: 'rffwhidWizard1WireAutoStep2Ctrl',
        params: {
            onewireData: null
        }
    });
}]).controller('rffwhidWizard1WireAutoStep1Ctrl', function($scope, $timeout, $mdDialog, $state, $translate, RFHelper) {
    $scope.propsRemoved = false;
    $scope.busy = false;

    $scope.next = function () {
        $scope.busy = true;
        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("rffwhid.rffwhid_wizard_1wire_auto_step_1.DO_NOT_UNPOWER_ESCS_DIALOG_TITLE");
                $scope.RFFWHID.onewire({
                    commandArg: "auto",
                    deadlineTime: 120000,
                    success: function (onewireData) {
                        if ($scope.$$destroyed && dialogScope.$$destroyed) {
                            return
                        }
                        $scope.busy = false;
                        $mdDialog.hide();
                        $state.go('rffwhid.rffwhid_wizard_1wire_auto_step_2', {
                            onewireData: onewireData
                        });

                    },
                    error: function (err) {
                        if ($scope.$$destroyed && dialogScope.$$destroyed) {
                            return
                        }
                        $scope.busy = false;
                        $mdDialog.hide();
                        RFHelper.showOkDialog(err.name, err.message);
                    }
                });

            }
        });
    };

}).controller('rffwhidWizard1WireAutoStep2Ctrl', function($scope, $timeout, $mdDialog, $state, $stateParams, $translate, RFHelper) {
    $scope.output = $stateParams.onewireData
});