'use strict';

angular.module('rfApp.dfu_flash', [
    'ngRoute',
    'ngMaterial',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "dfu_flash",
            url: "/dfu_flash",
            templateUrl: 'views/dfu_flash/dfu_flash.html',
            controller: 'DFUFlashCtrl'
        })
}]).controller('DFUFlashCtrl', function($scope, $mdDialog, $timeout, $translate, $q, RFHelper) {
    $scope.busy = false;

    $scope.load_firmware_locally = function (ev) {
        $scope.busy = true;

        chrome.fileSystem.chooseEntry({
            type: 'openFile',
            accepts: [{
                description: 'Raw Binary (.bin)',
                extensions: ['bin']
            }]
        }, function (fileEntry) {
            if (chrome.runtime.lastError) {
                $timeout(function () {
                    $scope.busy = false;
                });

                console.error(chrome.runtime.lastError.message);
                return;
            }

            chrome.fileSystem.getDisplayPath(fileEntry, function (path) {
                console.log('Loading file from: ' + path);

                fileEntry.file(function (file) {
                    var reader = new FileReader();

                    reader.onloadend = function(e) {
                        if (e.total > 1048576) {
                            RFHelper.showOkDialog($translate.instant('ERROR'), $translate.instant('FILE_LIMIT_ERROR')).then(function(){
                                $scope.busy = false;
                            });
                            reader.abort();
                            return
                        }
                        if (e.total == 0 || e.total != e.loaded) {
                            RFHelper.showOkDialog($translate.instant('ERROR'), $translate.instant('LOAD_FILE_ERROR')).then(function(){
                                $scope.busy = false;
                            });
                            reader.abort();
                            return
                        }

                        $mdDialog.show({
                            controller: 'loadingDialogCtrl',
                            templateUrl: 'tmpl/loadingDialog.tmpl.html',
                            onComplete: function (dialogScope, element) {

                                var data = new Uint8Array(e.target.result);

                                var hex = {
                                    data:                   [],
                                    end_of_file:            true,
                                    bytes_total:            data.length,
                                    start_linear_address:   0x8000000 // start of STM32 flash, i love assumptions
                                };

                                var verify_hex = [];

                                var block_size = 1048576; // the flashing code assumes this... sigh

                                for (var address = 0; address < hex.bytes_total; address += block_size) {
                                    if (address + block_size > hex.bytes_total)
                                        block_size = hex.bytes_total - address;
                                    hex.data.push({
                                        "data": data.slice(address, address + block_size),
                                        "bytes": block_size,
                                        "address": hex.start_linear_address + address
                                    });
                                }

                                var uploadChain = $q.when();

                                var available_flash_size;
                                var flash_layout = { 'start_address': 0, 'total_size': 0, 'sectors': []};

                                dialogScope.mode = 1;

                                uploadChain.then(function() {
                                    var deferred = $q.defer();

                                    $timeout(function () {
                                        dialogScope.status = $translate.instant("dfu.GETTING_FLASH_INFO_STATUS");
                                        dialogScope.additionalStatus = $translate.instant("dfu.DO_NOT_DISCONNECT_BOARD_ADDITIONAL_STATUS");

                                        $scope.DFU.getFlashInfo(0, function (flash, resultCode) {
                                            if (resultCode != 0) {
                                                // console.log('Failed to detect chip flash info, resultCode: ' + resultCode);
                                                // self.upload_procedure(99);

                                                deferred.reject(new Error(
                                                    'Failed to detect chip flash info, resultCode: '+resultCode
                                                ));
                                            } else {
                                                flash_layout = flash;
                                                available_flash_size = flash.total_size - (hex.start_linear_address - flash.start_address);

                                                $scope.DFU.clearStatus(function () {
                                                    // $scope.upload_procedure(2);
                                                    deferred.resolve();
                                                });

                                            }
                                        });
                                    }, 0);
                                    return deferred.promise;
                                }, function (err) {
                                    return $q.reject(err);
                                }).then(function () {
                                    var deferred = $q.defer();
                                    // local erase

                                    $timeout(function () {
                                        dialogScope.status = $translate.instant("dfu.ERASING_CHIP_STATUS");
                                        dialogScope.progress = 0;

                                        // find out which pages to erase
                                        var erase_pages = [];
                                        for (var i = 0; i < flash_layout.sectors.length; i++) {
                                            for (var j = 0; j < flash_layout.sectors[i].num_pages; j++) {
                                                var page_start = flash_layout.sectors[i].start_address + j * flash_layout.sectors[i].page_size;
                                                var page_end = page_start + flash_layout.sectors[i].page_size - 1;
                                                for (var k = 0; k < hex.data.length; k++) {
                                                    var starts_in_page = hex.data[k].address >= page_start && hex.data[k].address <= page_end;
                                                    var end_address = hex.data[k].address + hex.data[k].bytes - 1;
                                                    var ends_in_page = end_address >= page_start && end_address <= page_end;
                                                    var spans_page = hex.data[k].address < page_start && end_address > page_end;
                                                    if (starts_in_page || ends_in_page || spans_page) {
                                                        var idx = erase_pages.findIndex(function (element, index, array) {
                                                            return element.sector == i && element.page == j;
                                                        });
                                                        if (idx == -1)
                                                            erase_pages.push({'sector': i, 'page': j});
                                                    }
                                                }
                                            }
                                        }


                                        console.log('Executing local chip erase');

                                        var page = 0;
                                        var total_erased = 0; // bytes

                                        var erase_page = function() {
                                            var page_addr = erase_pages[page].page * flash_layout.sectors[erase_pages[page].sector].page_size +
                                                flash_layout.sectors[erase_pages[page].sector].start_address;
                                            var cmd = [0x41, page_addr & 0xff, (page_addr >> 8) & 0xff, (page_addr >> 16) & 0xff, (page_addr >> 24) & 0xff];
                                            total_erased += flash_layout.sectors[erase_pages[page].sector].page_size;
                                            console.log('Erasing. sector ' + erase_pages[page].sector +
                                                ', page ' + erase_pages[page].page + ' @ 0x' + page_addr.toString(16));

                                            $scope.DFU.controlTransfer('out', $scope.DFU.request.DNLOAD, 0, 0, 0, cmd, function () {
                                                $scope.DFU.controlTransfer('in', $scope.DFU.request.GETSTATUS, 0, 0, 6, 0, function (data) {
                                                    if (data[4] == $scope.DFU.state.dfuDNBUSY) { // completely normal
                                                        var delay = data[1] | (data[2] << 8) | (data[3] << 16);

                                                        $timeout(function () {
                                                            $scope.DFU.controlTransfer('in', $scope.DFU.request.GETSTATUS, 0, 0, 6, 0, function (data) {
                                                                if (data[4] == $scope.DFU.state.dfuDNLOAD_IDLE) {
                                                                    // update progress bar
                                                                    $timeout(function () {
                                                                        //self.progress_bar_e.val((page + 1) / erase_pages.length * 100);
                                                                        page++;
                                                                        dialogScope.progress = (page + 1) / erase_pages.length * 100;

                                                                        if(page == erase_pages.length) {
                                                                            console.log("Erase: complete");
                                                                            //dialogScope.additionalStatus = (total_erased / 1024).toString();
                                                                            //GUI.log(chrome.i18n.getMessage('dfu_erased_kilobytes', (total_erased / 1024).toString()));
                                                                            //self.upload_procedure(4);
                                                                            deferred.resolve()
                                                                        } else {
                                                                            erase_page();
                                                                        }
                                                                    }, 0);


                                                                } else {
                                                                    console.log('Failed to erase page 0x' + page_addr.toString(16));
                                                                    //self.upload_procedure(99);
                                                                    deferred.reject(
                                                                        new Error(
                                                                            'Failed to erase page 0x' + page_addr.toString(16)
                                                                        )
                                                                    );
                                                                }
                                                            });
                                                        }, delay);
                                                    } else {
                                                        console.log('Failed to initiate page erase, page 0x' + page_addr.toString(16));
                                                        deferred.reject(
                                                            new Error(
                                                                'Failed to initiate page erase, page 0x' + page_addr.toString(16)
                                                            )
                                                        );
                                                        //self.upload_procedure(99);
                                                    }
                                                });
                                            });
                                        };

                                        // start
                                        erase_page();

                                    }, 0);

                                    return deferred.promise;
                                }, function (err) {
                                    return $q.reject(err)
                                }).then(function () {
                                    // upload
                                    // we dont need to clear the state as we are already using DFU_DNLOAD

                                    var deferred = $q.defer();

                                    $timeout(function () {
                                        console.log('Writing data ...');
                                        dialogScope.status = $translate.instant("dfu.WRITING_DATA_STATUS");
                                        dialogScope.progress = 0;
                                        //$('span.progressLabel').text('Flashing ...');

                                        var blocks = hex.data.length - 1;
                                        var flashing_block = 0;
                                        var address = hex.data[flashing_block].address;

                                        var bytes_flashed = 0;
                                        var bytes_flashed_total = 0; // used for progress bar
                                        var wBlockNum = 2; // required by DFU

                                        var write = function () {
                                            if (bytes_flashed < hex.data[flashing_block].bytes) {
                                                var bytes_to_write = ((bytes_flashed + 2048) <= hex.data[flashing_block].bytes) ? 2048 : (hex.data[flashing_block].bytes - bytes_flashed);

                                                var data_to_flash = hex.data[flashing_block].data.slice(bytes_flashed, bytes_flashed + bytes_to_write);

                                                address += bytes_to_write;
                                                bytes_flashed += bytes_to_write;
                                                bytes_flashed_total += bytes_to_write;

                                                $scope.DFU.controlTransfer('out', $scope.DFU.request.DNLOAD, wBlockNum++, 0, 0, data_to_flash, function () {
                                                    $scope.DFU.controlTransfer('in', $scope.DFU.request.GETSTATUS, 0, 0, 6, 0, function (data) {
                                                        if (data[4] == $scope.DFU.state.dfuDNBUSY) {
                                                            var delay = data[1] | (data[2] << 8) | (data[3] << 16);

                                                            $timeout(function () {
                                                                $scope.DFU.controlTransfer('in', $scope.DFU.request.GETSTATUS, 0, 0, 6, 0, function (data) {
                                                                    if (data[4] == $scope.DFU.state.dfuDNLOAD_IDLE) {
                                                                        $timeout(function () {
                                                                            // update progress bar
                                                                            //self.progress_bar_e.val(bytes_flashed_total / (self.hex.bytes_total * 2) * 100);
                                                                            dialogScope.progress = bytes_flashed_total / (hex.bytes_total * 2) * 100;
                                                                            // flash another page
                                                                            write();
                                                                        }, 0);

                                                                    } else {
                                                                        console.log('Failed to write ' + bytes_to_write + 'bytes to 0x' + address.toString(16));
                                                                        //self.upload_procedure(99);
                                                                        deferred.reject(
                                                                            new Error(
                                                                                'Failed to write ' + bytes_to_write + 'bytes to 0x' + address.toString(16)
                                                                            )
                                                                        )
                                                                    }
                                                                });
                                                            }, delay);
                                                        } else {
                                                            console.log('Failed to initiate write ' + bytes_to_write + 'bytes to 0x' + address.toString(16));
                                                            //self.upload_procedure(99);
                                                            deferred.reject(
                                                                new Error(
                                                                    'Failed to initiate write ' + bytes_to_write + 'bytes to 0x' + address.toString(16)
                                                                )
                                                            )
                                                        }
                                                    });
                                                })
                                            } else {
                                                if (flashing_block < blocks) {
                                                    // move to another block
                                                    flashing_block++;

                                                    address = hex.data[flashing_block].address;
                                                    bytes_flashed = 0;
                                                    wBlockNum = 2;

                                                    $scope.DFU.loadAddress(address, write);
                                                } else {
                                                    // all blocks flashed
                                                    console.log('Writing: done');

                                                    // proceed to next step
                                                    //self.upload_procedure(5);

                                                    deferred.resolve();
                                                }
                                            }
                                        };

                                        // start
                                        $scope.DFU.loadAddress(address, write);
                                    }, 0);

                                    return deferred.promise;

                                }, function (err) {
                                    return $q.reject(err);
                                }).then(function () {
                                    // verify

                                    var deferred = $q.defer();

                                    $timeout(function () {
                                        console.log('Verifying data ...');
                                        dialogScope.status = $translate.instant("dfu.VERIFYING_DATA_STATUS");
                                        dialogScope.progress = 0;
                                        //$('span.progressLabel').text('Verifying ...');

                                        var blocks = hex.data.length - 1;
                                        var reading_block = 0;
                                        var address = hex.data[reading_block].address;

                                        var bytes_verified = 0;
                                        var bytes_verified_total = 0; // used for progress bar
                                        var wBlockNum = 2; // required by DFU

                                        // initialize arrays
                                        for (var i = 0; i <= blocks; i++) {
                                            verify_hex.push([]);
                                        }

                                        // start
                                        $scope.DFU.clearStatus(function () {
                                            $scope.DFU.loadAddress(address, function () {
                                                $scope.DFU.clearStatus(read);
                                            });
                                        });

                                        var read = function () {
                                            if (bytes_verified < hex.data[reading_block].bytes) {
                                                var bytes_to_read = ((bytes_verified + 2048) <= hex.data[reading_block].bytes) ? 2048 : (hex.data[reading_block].bytes - bytes_verified);

                                                $scope.DFU.controlTransfer('in', $scope.DFU.request.UPLOAD, wBlockNum++, 0, bytes_to_read, 0, function (data, code) {
                                                    for (var i = 0; i < data.length; i++) {
                                                        verify_hex[reading_block].push(data[i]);
                                                    }

                                                    address += bytes_to_read;
                                                    bytes_verified += bytes_to_read;
                                                    bytes_verified_total += bytes_to_read;

                                                    // update progress bar
                                                    //self.progress_bar_e.val((self.hex.bytes_total + bytes_verified_total) / (self.hex.bytes_total * 2) * 100);

                                                    // verify another page
                                                    $timeout(function () {
                                                        dialogScope.progress = (hex.bytes_total + bytes_verified_total)/(hex.bytes_total * 2) * 100;
                                                        read();
                                                    }, 0);
                                                });
                                            } else {
                                                if (reading_block < blocks) {
                                                    // move to another block
                                                    reading_block++;

                                                    address = hex.data[reading_block].address;
                                                    bytes_verified = 0;
                                                    wBlockNum = 2;

                                                    $scope.DFU.clearStatus(function () {
                                                        $scope.DFU.loadAddress(address, function () {
                                                            $scope.DFU.clearStatus(read);
                                                        });
                                                    });
                                                } else {
                                                    // all blocks read, verify

                                                    var verify = true;
                                                    for (var i = 0; i <= blocks; i++) {
                                                        verify = $scope.DFU.verify_flash(hex.data[i].data, verify_hex[i]);

                                                        if (!verify) break;
                                                    }

                                                    if (verify) {
                                                        console.log('Programming: SUCCESSFUL');
                                                        //$('span.progressLabel').text('Programming: SUCCESSFUL');
                                                        //googleAnalytics.sendEvent('Flashing', 'Programming', 'success');

                                                        // update progress bar
                                                        //self.progress_bar_e.addClass('valid');

                                                        // proceed to next step
                                                        //self.upload_procedure(6);
                                                        deferred.resolve();
                                                    } else {
                                                        console.log('Programming: FAILED');
                                                        //$('span.progressLabel').text('Programming: FAILED');
                                                        //googleAnalytics.sendEvent('Flashing', 'Programming', 'fail');

                                                        // update progress bar
                                                        //self.progress_bar_e.addClass('invalid');

                                                        // disconnect
                                                        //self.upload_procedure(99);
                                                        deferred.reject(
                                                            new Error('Programming: FAILED')
                                                        )
                                                    }
                                                }
                                            }
                                        };
                                    }, 0);



                                    return deferred.promise;
                                }, function (err) {
                                    return $q.reject(err);
                                }).then(function () {
                                    // jump to application code
                                    var address = hex.data[0].address;

                                    $scope.DFU.clearStatus(function () {
                                        $scope.DFU.loadAddress(address, leave);
                                    });

                                    var leave = function () {
                                        $scope.DFU.controlTransfer('out', $scope.DFU.request.DNLOAD, 0, 0, 0, 0, function () {
                                            $scope.DFU.controlTransfer('in', $scope.DFU.request.GETSTATUS, 0, 0, 6, 0, function (data) {
                                                $scope.DFU.releaseInterface(0);
                                                $mdDialog.hide();
                                                $scope.busy = false;
                                            });
                                        });
                                    }

                                }, function (err) {
                                    $scope.DFU.releaseInterface(0);
                                    $mdDialog.hide();
                                    $scope.busy = false;
                                    RFHelper.showOkDialog(err.name, err.message);
                                });
                            }
                        });
                    };
                    reader.readAsArrayBuffer(file);
                });
            });
        });
    };

});

