'use strict';

var app = angular.module('rfApp', [
    'ngMaterial',
    'ui.router',
    'ngCookies',
    'pascalprecht.translate',
    'rfApp.user_settings',
    'rfApp.device_not_found',
    'rfApp.dfu_flash',
    'rfApp.rffwhid',
    'rfApp.rffwhid_overview',
    'rfApp.rffwhid_telemetry',
    'rfApp.rffwhid_console',
    'rfApp.rffwhid_pid_tuning',
    'rfApp.rffwhid_setup',
    'rfApp.rffwhid_configuration',
    'rfApp.rffwhid_logging',
    'rfApp.rffwhid_esc',
    'rfApp.rffwhid_help',
    'rfApp.rffwhid_rfbl_flash',
    'rfApp.rffwhid_wizard_1wire_auto',
    'rfApp.rffwhid_wizard_wiz_mot',
    'rfApp.rffwhid_wizard_rca',
    'rfApp.rffwhid_wizard_rx',
    'rfApp.rffwhid_wizard_fc',
    'rfApp.rffwhid_wizard_fix_motor_direction',
    'rfApp.rffwhid_wizard_bind_spektrum',
    'rfApp.rffwhid_wizard_vtx',
    'DFUService',
    'RFFWHIDService',
    'RFFWHIDRFBLService',
    'RFHelperService'
]).config([
    '$stateProvider',
    '$urlRouterProvider',
    '$urlMatcherFactoryProvider',
    '$mdThemingProvider',
    '$compileProvider',
    '$translateProvider',
    function($stateProvider, $urlRouterProvider, $urlMatcherFactoryProvider, $mdThemingProvider, $compileProvider, $translateProvider) {

        //http://stackoverflow.com/a/15769779/1786016
        $compileProvider.imgSrcSanitizationWhitelist(/^\s*(https?|local|data|chrome-extension):/);

        var redRFPalette = $mdThemingProvider.extendPalette('red', {
            '500': 'b31b16',
        });

        $mdThemingProvider.definePalette('redRFPalette', redRFPalette);

        $mdThemingProvider.theme('default')
            .primaryPalette('redRFPalette')
            .backgroundPalette('grey');

        $translateProvider.useStaticFilesLoader({
            prefix: 'resources/translations/',
            suffix: '.json'
        });

        $translateProvider.preferredLanguage('en').fallbackLanguage('en');

        $translateProvider.useLocalStorage();
        //https://angular-translate.github.io/docs/#/guide/19_security
        $translateProvider.useSanitizeValueStrategy(null);

        // for handling trailing slashes
        $urlMatcherFactoryProvider.strictMode(false);
}]).run([
    '$rootScope',
    '$location',
    '$state',
    '$mdDialog',
    '$timeout',
    '$translate',
    'DFU',
    'RFFWHID',
    'RFFWHIDRFBL',
    'RFHelper',
    function($rootScope, $location, $state, $mdDialog, $timeout, $translate, DFU, RFFWHID, RFFWHIDRFBL, RFHelper){
        // nw.App.clearCache();

        $rootScope.RFFWHID = RFFWHID;
        $rootScope.RFFWHIDRFBL = RFFWHIDRFBL;
        $rootScope.DFU = DFU;

        $rootScope.openExternalLink = function (link) {
            nw.Shell.openExternal(link);
        };

        //move code into factory
        $rootScope.checkForDevices = function() {
            if ($rootScope.RFFWHID.connectionId || $rootScope.RFFWHIDRFBL.connectionId) {
                return
            }

            $rootScope.RFFWHID.getDevices(function(devicesInfo) {
                if(devicesInfo.length > 0) {
                    $rootScope.RFFWHID.connect({
                        deviceInfo: devicesInfo[0],
                        success: function () {
                            $timeout(function () {
                                $mdDialog.show({
                                    controller: 'loadingDialogCtrl',
                                    templateUrl: 'tmpl/loadingDialog.tmpl.html',
                                    onComplete: function (dialogScope, element) {
                                        $rootScope.RFFWHID.dump({
                                            populateDump: true,
                                            success: function () {
                                                console.log($rootScope.RFFWHID.RFDump);
                                                $mdDialog.hide();
                                                $state.go('rffwhid');
                                            },
                                            error: function (err) {

                                                RFHelper.showConfirmDialog(
                                                    $translate.instant("ERROR"),
                                                    $translate.instant("app.LOADING_BOARD_FAILED_CONFIRM_DIALOG_MESSAGE"),
                                                    $translate.instant("CANCEL"),
                                                    $translate.instant("app.UPDATE_FIRMWARE_CONFIRM_DIALOG_BUTTON")
                                                ).then(function() {
                                                    $mdDialog.hide();
                                                    $rootScope.RFFWHID.rebootRFBL();
                                                }, function() {
                                                    $mdDialog.hide();
                                                    $rootScope.RFFWHID.disconnect();

                                                    $state.go('device_not_found');
                                                });
                                            }
                                        });
                                    }
                                });
                            }, 10);
                        },
                        error: function (err) {
                            $mdDialog.hide();
                            RFHelper.showOkDialog(err.name, err.message).then(function(){
                                $rootScope.RFFWHID.disconnect();
                            });
                        }
                    });
                } else {
                    $rootScope.RFFWHIDRFBL.getDevices(function(devicesInfo) {
                        if(devicesInfo.length > 0) {
                            $rootScope.RFFWHIDRFBL.connect({
                                deviceInfo: devicesInfo[0],
                                success: function () {
                                    $mdDialog.hide();
                                    $state.go('rffwhid_rfbl');
                                },
                                error: function (err) {
                                    $mdDialog.hide();
                                    RFHelper.showOkDialog(err.name, err.message).then(function(){
                                        $rootScope.RFFWHIDRFBL.disconnect();
                                    });
                                }
                            });
                        } else {
                            $rootScope.DFU.getDevices(function(devicesInfo) {
                                if(devicesInfo.length > 0) {
                                    $rootScope.DFU.connect({
                                        deviceInfo: devicesInfo[0],
                                        success: function () {
                                            $mdDialog.hide();
                                            $state.go('dfu_flash');
                                        },
                                        error: function (err) {
                                            $mdDialog.hide();
                                            RFHelper.showOkDialog(err.name, err.message).then(function(){
                                                $rootScope.DFU.disconnect();
                                            });
                                        }
                                    });
                                } else {
                                    $mdDialog.hide();
                                    $state.go('device_not_found');
                                }
                            });
                        }
                    });
                }
            });
        };

        chrome.hid.onDeviceAdded.addListener(function(deviceInfo) {
            $rootScope.checkForDevices();
        });

        chrome.hid.onDeviceRemoved.addListener(function(device_id) {
            $mdDialog.hide();
            if ($rootScope.RFFWHID.deviceInfo && ($rootScope.RFFWHID.deviceInfo.deviceId) == device_id) {
                $rootScope.RFFWHID.disconnect();
                $rootScope.RFFWHID.busy = false;
                if($rootScope.RFFWHID.busyTimeout) {
                    $timeout.cancel($rootScope.RFFWHID.busyTimeout);
                }
                $rootScope.RFFWHID.busyTimeout = null;
                $rootScope.checkForDevices();
            } else if($rootScope.RFFWHIDRFBL.deviceInfo && ($rootScope.RFFWHIDRFBL.deviceInfo.deviceId) == device_id) {
                $rootScope.RFFWHIDRFBL.disconnect();
                $rootScope.checkForDevices();
            }
        });

        chrome.usb.onDeviceRemoved.addListener(function(device) {
            $mdDialog.hide();
            if ($rootScope.DFU.deviceInfo && ($rootScope.DFU.deviceInfo.device) == device.device) {
                $rootScope.DFU.disconnect();
                $rootScope.checkForDevices();
            }
        });

        var win = nw.Window.get();

        win.on('close', function() {
            if ($rootScope.RFFWHID.connectionId) {
                $rootScope.RFFWHID.disconnect();
            } else if ($rootScope.RFFWHIDRFBL.connectionId) {
                $rootScope.RFFWHID.disconnect();
            }
            nw.App.quit();
        });

        var escShortcut = new nw.Shortcut({
            key: "Escape",
            active: function () {
                win.leaveFullscreen();
            },
            failed : function(msg) {
                // :(, fail to register the |key| or couldn't parse the |key|.
                console.log(msg);
            }
        });

        nw.App.registerGlobalHotKey(escShortcut);

        var fs = require('fs');
        var path = require('path');

        var file = 'user_settings.json';
        var filePath = path.join(nw.App.dataPath, file);

        $rootScope.USER_SETTINGS = {
            'device_not_found_video_loop_enabled': true
        };

        try {
            $rootScope.USER_SETTINGS = JSON.parse(fs.readFileSync(filePath, 'utf8'));
            $rootScope.checkForDevices();
        } catch(e) {
            console.log(e); // error in the above string (in this case, yes)!

            fs.writeFile(filePath, JSON.stringify($rootScope.USER_SETTINGS), function (err) {
                if (err) {
                    console.info("There was an error attempting to save your data.");
                    console.warn(err.message);
                }
                $rootScope.checkForDevices();
            });
        }

}]).controller('loadingDialogCtrl', function($scope, $mdDialog, $rootScope, $translate, RFHelper) {
    $scope.title = $translate.instant("PLEASE_WAIT");
    $scope.status = $translate.instant("LOADING");
    $scope.mode = 0;
    $scope.progress = 0;
    $scope.additionalStatus = "";
    $scope.buttons = null;

    $scope.modes = ["indeterminate", "determinate"];
}).controller('confirmDialogCtrl', function($scope, $mdDialog, $rootScope, title, textContent, buttons) {
    $scope.title = title;
    $scope.textContent = textContent;
    $scope.buttons = buttons;
});

