'use strict';

angular.module('rfApp.rffwhid_wizard_fc', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
        name: "rffwhid.rffwhid_wizard_fc_step_1",
        url: "/rffwhid_wizard_fc_step_1",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_fc_step1.html",
        controller: 'rffwhidWizardFcStep1Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_fc_step_2",
        url: "/rffwhid_wizard_fc_step_2",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_fc_step2.html",
        controller: 'rffwhidWizardFcStep2Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_fc_step_3",
        url: "/rffwhid_wizard_fc_step_3",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_fc_step3.html",
        controller: 'rffwhidWizardFcStep3Ctrl'
    });
}]).controller('rffwhidWizardFcStep1Ctrl', function($scope, $state, $translate, RFHelper) {
    $scope.busy = false;

    $scope.next = function () {
        $scope.busy = true;
        $scope.RFFWHID.wizCala({
            success: function (wizCalaData) {
                $scope.busy = false;
                for (var i=0; i<wizCalaData.length; i++) {
                    if (wizCalaData[i].indexOf("calibrate1finished") != -1) {
                        $state.go('rffwhid.rffwhid_wizard_fc_step_2');
                        return
                    }
                }
            },
            error: function (err) {
                RFHelper.showOkDialog(err.name, err.message).then(function() {
                    $scope.busy = false;
                });
            }
        });
    }
}).controller('rffwhidWizardFcStep2Ctrl', function($scope, $state, $translate, RFHelper) {
    $scope.busy = false;

    $scope.next = function () {
        $scope.busy = true;

        $scope.RFFWHID.wizCalb({
            success: function (wizCalbData) {
                $scope.busy = false;
                for (var i=0; i<wizCalbData.length; i++) {
                    if (wizCalbData[i].indexOf("calibrate2finished") != -1) {
                        $state.go('rffwhid.rffwhid_wizard_fc_step_3');
                        return
                    }
                }
            },
            error: function (err) {
                RFHelper.showOkDialog(err.name, err.message).then(function() {
                    $scope.busy = false;
                });
            }
        });
    }
}).controller('rffwhidWizardFcStep3Ctrl', function($scope, $state) {

});