'use strict';

angular.module('rfApp.rffwhid_rfbl_flash', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid_rfbl",
            url: "/rffwhid_rfbl_flash",
            templateUrl: "views/rffwhid_rfbl_flash/rffwhid_rfbl_flash.html",
            controller: 'rffwhidRFBLFlashCtrl'
        });
}]).controller('rffwhidRFBLFlashCtrl', function($scope, $mdDialog, $timeout, $translate, RFHelper) {
    $scope.busy = false;

    function strToCharArray (s) {
        var carr = new Uint8Array(4);
        for (var i = 0; i < s.length && i < carr.length; ++i) {
            if (s.charCodeAt(i) > 255) {
                throw "I am not smart enough to decode non-ASCII data.";
            }
            carr[i] = s.charCodeAt(i);
        }
        return carr;
    }

    function decToCharArray (b) {
        // No idea what does this code do
        var carray = new Uint8Array(4);
        b = b.toString(16);
        b = b.split("");
        b.reverse();
        var catfish = 0;
        while (catfish < 8) {
            if (b[catfish] == undefined) {
                b[catfish] = 0;
            }
            if (b[catfish] == null) {
                b[catfish] = 0;
            }
            catfish++;
        }
        carray[0] = parseInt(b[7] + b[6], 16);
        carray[1] = parseInt(b[5] + b[4], 16);
        carray[2] = parseInt(b[3] + b[2], 16);
        carray[3] = parseInt(b[1] + b[0], 16);
        return carray;

    }

    function generateStartPacket(fwSize, fwType, fwMode, fwAddr, fwEras, fwSkip) {
        var fwPack = new Uint8Array($scope.RFFWHIDRFBL.reportSize);
        var temp_arr = strToCharArray("RFBL");
        fwPack[0] = temp_arr[0];
        fwPack[1] = temp_arr[1];
        fwPack[2] = temp_arr[2];
        fwPack[3] = temp_arr[3];
        temp_arr = strToCharArray("CCCC");
        fwPack[4] = temp_arr[3];
        fwPack[5] = 5;

        temp_arr = strToCharArray("FWSZ");
        fwPack[6] = temp_arr[0];
        fwPack[7] = temp_arr[1];
        fwPack[8] = temp_arr[2];
        fwPack[9] = temp_arr[3];
        temp_arr = decToCharArray(fwSize - fwSkip);
        fwPack[10] = temp_arr[0];
        fwPack[11] = temp_arr[1];
        fwPack[12] = temp_arr[2];
        fwPack[13] = temp_arr[3];

        temp_arr = strToCharArray("FWTP");
        fwPack[14] = temp_arr[0];
        fwPack[15] = temp_arr[1];
        fwPack[16] = temp_arr[2];
        fwPack[17] = temp_arr[3];
        temp_arr = strToCharArray(fwType);
        fwPack[18] = temp_arr[0];
        fwPack[19] = temp_arr[1];
        fwPack[20] = temp_arr[2];
        fwPack[21] = temp_arr[3];

        temp_arr = strToCharArray("FWMD");
        fwPack[22] = temp_arr[0];
        fwPack[23] = temp_arr[1];
        fwPack[24] = temp_arr[2];
        fwPack[25] = temp_arr[3];
        temp_arr = strToCharArray(fwMode);
        fwPack[26] = temp_arr[0];
        fwPack[27] = temp_arr[1];
        fwPack[28] = temp_arr[2];
        fwPack[29] = temp_arr[3];

        temp_arr = strToCharArray("FWER");
        fwPack[30] = temp_arr[0];
        fwPack[31] = temp_arr[1];
        fwPack[32] = temp_arr[2];
        fwPack[33] = temp_arr[3];
        temp_arr = decToCharArray(fwEras);
        fwPack[34] = temp_arr[0];
        fwPack[35] = temp_arr[1];
        fwPack[36] = temp_arr[2];
        fwPack[37] = temp_arr[3];

        temp_arr = strToCharArray("FWAD");
        fwPack[38] = temp_arr[0];
        fwPack[39] = temp_arr[1];
        fwPack[40] = temp_arr[2];
        fwPack[41] = temp_arr[3];
        temp_arr = decToCharArray(fwAddr);
        fwPack[42] = temp_arr[0];
        fwPack[43] = temp_arr[1];
        fwPack[44] = temp_arr[2];
        fwPack[45] = temp_arr[3];


        var i = 46;
        while (i < $scope.RFFWHIDRFBL.reportSize) {
            fwPack[i] = 0;
            i++;
        }
        fwPack[$scope.RFFWHIDRFBL.reportSize-1] = 1;
        return fwPack
    }

    $scope.rebootToFC = function () {
        var bytes = new Uint8Array([82, 70, 66, 76, 67, 3]);

        $scope.RFFWHIDRFBL.send({
            data: bytes
        })
    };

    $scope.rebootToDFU = function () {
        var bytes = new Uint8Array([82, 70, 66, 76, 67, 1]);
        $scope.RFFWHIDRFBL.send({
            data: bytes
        })
    };

    $scope.load_firmware_locally = function (ev) {
        $scope.busy = true;

        chrome.fileSystem.chooseEntry({
            type: 'openFile',
            accepts: [{
                description: 'Raw Binary (.bin)',
                extensions: ['bin']
            }]
        }, function (fileEntry) {
            if (chrome.runtime.lastError) {
                $timeout(function () {
                    $scope.busy = false;
                });

                console.error(chrome.runtime.lastError.message);
                return;
            }

            chrome.fileSystem.getDisplayPath(fileEntry, function (path) {
                console.log('Loading file from: ' + path);

                fileEntry.file(function (file) {
                    var reader = new FileReader();

                    reader.onloadend = function(e) {
                        if (e.total > 1048576) {
                            RFHelper.showOkDialog($translate.instant('ERROR'), $translate.instant('FILE_LIMIT_ERROR')).then(function(){
                                $scope.busy = false;
                            });
                            reader.abort();
                            return
                        }
                        if (e.total == 0 || e.total != e.loaded) {
                            RFHelper.showOkDialog($translate.instant('ERROR'), $translate.instant('LOAD_FILE_ERROR')).then(function(){
                                $scope.busy = false;
                            });
                            reader.abort();
                            return
                        }

                        $mdDialog.show({
                            controller: 'loadingDialogCtrl',
                            templateUrl: 'tmpl/loadingDialog.tmpl.html',
                            onComplete: function (dialogScope, element) {
                                var raw_file = e.target.result;
                                dialogScope.status = $translate.instant('rffwhid_rfbl.PREPARE_BOARD_FOR_FLASHING_STATUS');

                                var fwSize = e.total;
                                var fwType = "MANU";
                                var fwMode = "MANU";
                                var fwAddr = 0x08020000;
                                var fwEras = 0x08020000 + fwSize; //erase only what we need to
                                var fwSkip = 0;

                                if (e.total <= 32768) {
                                    //bootloader
                                    fwType = "MANU";
                                    fwMode = "MANU";
                                    fwAddr = 0x08008000;
                                    fwEras = 0x08008000 + 32767; //erase only bootloader section
                                    fwSkip = 0;
                                } else if (e.total == 524288) { //512 kb sized firmware
                                    //full concat firmware for 512 kb chips
                                    fwType = "MANU";
                                    fwMode = "MANU";
                                    fwAddr = 0x08020000;
                                    fwEras = 0x0807FFF0;
                                    fwSkip = 131072;
                                } else if (e.total == 1048576) { //512 kb sized firmware
                                    //full concat firmware for 1024 kb chips
                                    fwType = "MANU";
                                    fwMode = "MANU";
                                    fwAddr = 0x08020000;
                                    fwEras = 0x080FFFF0;
                                    fwSkip = 131072;
                                }

                                $scope.RFFWHIDRFBL.sendAndReceive({
                                    data: generateStartPacket(fwSize, fwType, fwMode, fwAddr, fwEras, fwSkip),
                                    success: function (reportId, data) {
                                        // console.log(data);
                                        console.log($scope.RFFWHIDRFBL.receivedDataToStr(data));

                                        $timeout(function(){
                                            dialogScope.status = $translate.instant('rffwhid_rfbl.FLASHING_STATUS');
                                            dialogScope.mode = 1;
                                            dialogScope.progress = 0;

                                            function sendFirmwareData(step) {
                                                var nextStep = step+($scope.RFFWHIDRFBL.reportSize-3); //last 3 bytes should always be [0, 0, 1]
                                                var part = raw_file.slice(step, nextStep);
                                                part = Array.prototype.slice.call(new Uint8Array(part));
                                                part = part.concat([0, 0, 1]);
                                                //console.log(part.length)
                                                //console.log(new Uint8Array(raw_file.slice(step, nextStep)));
                                                $scope.RFFWHIDRFBL.send({
                                                    data: new Uint8Array(part),
                                                    success: function () {
                                                        $timeout(function(){
                                                            dialogScope.progress = nextStep*100/raw_file.byteLength;
                                                            dialogScope.additionalStatus = $translate.instant('rffwhid_rfbl.PACKAGES_LOAD_STATUS', {'loaded_packages': nextStep, 'total_packages': raw_file.byteLength});
                                                            if (nextStep<raw_file.byteLength) {
                                                                sendFirmwareData(nextStep);
                                                            } else {
                                                                $scope.busy = false;
                                                                $mdDialog.hide();
                                                                RFHelper.showOkDialog($translate.instant('SUCCESSFULLY_TITLE'), $translate.instant('rffwhid_rfbl.FIRMWARE_SUCCESSFULLY_FLASHED_MESSAGE')).then(function () {
                                                                    var fwPack = new Uint8Array($scope.RFFWHIDRFBL.reportSize);
                                                                    var temp_arr = strToCharArray("RFBL");
                                                                    fwPack[0] = temp_arr[0];
                                                                    fwPack[1] = temp_arr[1];
                                                                    fwPack[2] = temp_arr[2];
                                                                    fwPack[3] = temp_arr[3];
                                                                    temp_arr = strToCharArray("CCCC");
                                                                    fwPack[4] = temp_arr[3];
                                                                    fwPack[5] = 3;
                                                                    var i = 6;
                                                                    while (i < $scope.RFFWHIDRFBL.reportSize) {
                                                                        fwPack[i] = 0;
                                                                        i++;
                                                                    }
                                                                    fwPack[$scope.RFFWHIDRFBL.reportSize-1] = 1;
                                                                    $scope.RFFWHIDRFBL.send({
                                                                        data: fwPack
                                                                    })
                                                                });
                                                            }
                                                        }, 0);
                                                    },
                                                    error: function (err) {
                                                        $mdDialog.hide();
                                                        RFHelper.showOkDialog(err.name, err.message).then(function(){
                                                            $scope.busy = false;
                                                        });
                                                    }
                                                });
                                            }

                                            sendFirmwareData(fwSkip);
                                        }, 0);
                                    },
                                    error: function (err) {
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog(err.name, err.message).then(function(){
                                            $scope.busy = false;
                                        });
                                    }
                                });

                            }
                        });

                    };

                    reader.readAsArrayBuffer(file);
                });
            });
        });
    }

});