'use strict';

angular.module('rfApp.rffwhid_pid_tuning', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'chart.js',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid.pid_tuning",
            url: "/rffwhid_pid_tuning",
            templateUrl: "views/rffwhid_pid_tuning/rffwhid_pid_tuning.html",
            controller: 'rffwhidPidTuningViewCtrl'
        })
}]).controller('rffwhidPidTuningViewCtrl', function($scope, $timeout, $mdDialog, $mdMenu, $q, $translate, RFHelper) {
    $scope.initialized = false;
    $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);

    $mdDialog.show({
        controller: 'loadingDialogCtrl',
        templateUrl: 'tmpl/loadingDialog.tmpl.html',
        onComplete: function(dialogScope, element) {
            $scope.RFFWHID.dump({
                populateDump: true,
                success: function() {
                    //Wait for possible not finished received functions
                    $timeout(function() {
                        $mdDialog.hide();
                        $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
                        $scope.updateRateData();
                        $scope.initialized = true;
                    }, 50);
                },
                error: function(err) {
                    $mdDialog.hide();
                    RFHelper.showOkDialog(err.name, err.message);
                }
            });

        }
    });

    $scope.rate_names = {
        "3": {
            'name': $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_OPTION"),
            'options': {
                "roll_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_ROLL_RATE_LABEL"),
                "roll_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_ROLL_EXPO_LABEL"),
                "roll_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_ROLL_ACRO_PLUS_LABEL"),
                "pitch_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_PITCH_RATE_LABEL"),
                "pitch_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_PITCH_EXPO_LABEL"),
                "pitch_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_PITCH_ACRO_PLUS_LABEL"),
                "yaw_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_YAW_RATE_LABEL"),
                "yaw_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_YAW_EXPO_LABEL"),
                "yaw_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_LOW_EXPO_RATES_YAW_ACRO_PLUS_LABEL")
            }
        },
        "4": {
            'name': $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_OPTION"),
            'options': {
                "roll_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_ROLL_RATE_LABEL"),
                "roll_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_ROLL_EXPO_LABEL"),
                "roll_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_ROLL_ACRO_PLUS_LABEL"),
                "pitch_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_PITCH_RATE_LABEL"),
                "pitch_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_PITCH_EXPO_LABEL"),
                "pitch_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_PITCH_ACRO_PLUS_LABEL"),
                "yaw_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_YAW_RATE_LABEL"),
                "yaw_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_YAW_EXPO_LABEL"),
                "yaw_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_RACEFLIGHT_HIGH_EXPO_BB_RATES_YAW_ACRO_PLUS_LABEL")
            }
        },
        "5": {
            'name': $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_OPTION"),
            'options': {
                "roll_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_ROLL_RATE_LABEL"),
                "roll_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_ROLL_EXPO_LABEL"),
                "roll_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_ROLL_ACRO_PLUS_LABEL"),
                "pitch_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_PITCH_RATE_LABEL"),
                "pitch_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_PITCH_EXPO_LABEL"),
                "pitch_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_PITCH_ACRO_PLUS_LABEL"),
                "yaw_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_YAW_RATE_LABEL"),
                "yaw_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_YAW_EXPO_LABEL"),
                "yaw_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_KISS_RATES_YAW_ACRO_PLUS_LABEL")
            }
        },
        "7": {
            'name': $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_OPTION"),
            'options': {
                "roll_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_ROLL_RATE_LABEL"),
                "roll_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_ROLL_EXPO_LABEL"),
                "roll_acrop": $translate.instant("rffwhid.pid_tuning.RRATE_NAME_BETAFLIGHT_RATES_ROLL_ACRO_PLUS_LABEL"),
                "pitch_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_PITCH_RATE_LABEL"),
                "pitch_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_PITCH_EXPO_LABEL"),
                "pitch_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_PITCH_ACRO_PLUS_LABEL"),
                "yaw_rate": $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_YAW_RATE_LABEL"),
                "yaw_expo": $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_YAW_EXPO_LABEL"),
                "yaw_acrop": $translate.instant("rffwhid.pid_tuning.RATE_NAME_BETAFLIGHT_RATES_YAW_ACRO_PLUS_LABEL")
            }
        }
    };

    $scope.changePidLevel = function(level) {
        switch (level) {
            case "6s":
                $scope.RFDump.set.yaw_kp   = 90;
                $scope.RFDump.set.roll_kp  = 100;
                $scope.RFDump.set.pitch_kp = 100;
                $scope.RFDump.set.yaw_ki   = 1500;
                $scope.RFDump.set.roll_ki  = 1100;
                $scope.RFDump.set.pitch_ki = 1300;
                $scope.RFDump.set.yaw_kd   = 800;
                $scope.RFDump.set.roll_kd  = 1050;
                $scope.RFDump.set.pitch_kd = 1100;
                break;
            case "3inchSwiftMini":
                $scope.RFDump.set.yaw_kp   = 85;
                $scope.RFDump.set.roll_kp  = 80;
                $scope.RFDump.set.pitch_kp = 85;
                $scope.RFDump.set.yaw_ki   = 1500;
                $scope.RFDump.set.roll_ki  = 1100;
                $scope.RFDump.set.pitch_ki = 1300;
                $scope.RFDump.set.yaw_kd   = 1900;
                $scope.RFDump.set.roll_kd  = 1800;
                $scope.RFDump.set.pitch_kd = 2000;
                break;
            case "default":
                $scope.RFDump.set.yaw_kp   = 130;
                $scope.RFDump.set.roll_kp  = 110;
                $scope.RFDump.set.pitch_kp = 120;
                $scope.RFDump.set.yaw_ki   = 1500;
                $scope.RFDump.set.roll_ki  = 1100;
                $scope.RFDump.set.pitch_ki = 1300;
                $scope.RFDump.set.yaw_kd   = 1200;
                $scope.RFDump.set.roll_kd  = 0800;
                $scope.RFDump.set.pitch_kd = 1000;
                break;
            case "ShaunTaylor":
                $scope.RFDump.set.yaw_kp   = 105;
                $scope.RFDump.set.roll_kp  = 105;
                $scope.RFDump.set.pitch_kp = 125;
                $scope.RFDump.set.yaw_ki   = 1500;
                $scope.RFDump.set.roll_ki  = 900;
                $scope.RFDump.set.pitch_ki = 1300;
                $scope.RFDump.set.yaw_kd   = 766;
                $scope.RFDump.set.roll_kd  = 1100;
                $scope.RFDump.set.pitch_kd = 1200;
                break;
        }
    };

    $scope.changeRateLevel = function(level) {
        switch (level) {
            case "BeginnerRates":
                $scope.RFDump.set.pitch_rate  = 300;
                $scope.RFDump.set.roll_rate   = 300;
                $scope.RFDump.set.yaw_rate    = 300;

                $scope.RFDump.set.pitch_expo  = 50;
                $scope.RFDump.set.roll_expo   = 50;
                $scope.RFDump.set.yaw_expo    = 50;

                $scope.RFDump.set.pitch_acrop = 20;
                $scope.RFDump.set.roll_acrop  = 20;
                $scope.RFDump.set.yaw_acrop   = 20;
                break;

            case "DefaultRates":
                $scope.RFDump.set.pitch_rate  = 400;
                $scope.RFDump.set.roll_rate   = 400;
                $scope.RFDump.set.yaw_rate    = 400;

                $scope.RFDump.set.pitch_expo  = 50;
                $scope.RFDump.set.roll_expo   = 50;
                $scope.RFDump.set.yaw_expo    = 50;

                $scope.RFDump.set.pitch_acrop = 140;
                $scope.RFDump.set.roll_acrop  = 140;
                $scope.RFDump.set.yaw_acrop   = 140;
                break;

            case "ShaunRates":
                $scope.RFDump.set.pitch_rate  = 300;
                $scope.RFDump.set.roll_rate   = 300;
                $scope.RFDump.set.yaw_rate    = 150;

                $scope.RFDump.set.pitch_expo  = 50;
                $scope.RFDump.set.roll_expo   = 50;
                $scope.RFDump.set.yaw_expo    = 20;

                $scope.RFDump.set.pitch_acrop = 58;
                $scope.RFDump.set.roll_acrop  = 58;
                $scope.RFDump.set.yaw_acrop   = 40;
                break;

            case "SkitzoRates":
                $scope.RFDump.set.pitch_rate  = 800;
                $scope.RFDump.set.roll_rate   = 800;
                $scope.RFDump.set.yaw_rate    = 800;

                $scope.RFDump.set.pitch_expo  = 50;
                $scope.RFDump.set.roll_expo   = 50;
                $scope.RFDump.set.yaw_expo    = 50;

                $scope.RFDump.set.pitch_acrop = 150;
                $scope.RFDump.set.roll_acrop  = 150;
                $scope.RFDump.set.yaw_acrop   = 150;
                break;

            case "BrainDrainRates":
                $scope.RFDump.set.pitch_rate  = 300;
                $scope.RFDump.set.roll_rate   = 320;
                $scope.RFDump.set.yaw_rate    = 280;

                $scope.RFDump.set.pitch_expo  = 60;
                $scope.RFDump.set.roll_expo   = 60;
                $scope.RFDump.set.yaw_expo    = 25;

                $scope.RFDump.set.pitch_acrop = 0;
                $scope.RFDump.set.roll_acrop  = 0;
                $scope.RFDump.set.yaw_acrop   = 0;
                break;



        }

        $scope.updateRateData();
    };

    $scope.changeRates = function() {
        switch ($scope.RFDump.set.stick_curve) {
            case "3":
                $scope.RFDump.set.roll_rate   = 400;
                $scope.RFDump.set.roll_expo   = 50;
                $scope.RFDump.set.roll_acrop  = 140;
                $scope.RFDump.set.pitch_rate  = 400;
                $scope.RFDump.set.pitch_expo  = 50;
                $scope.RFDump.set.pitch_acrop = 140;
                $scope.RFDump.set.yaw_rate    = 400;
                $scope.RFDump.set.yaw_expo    = 50;
                $scope.RFDump.set.yaw_acrop   = 140;
                break;
            case "4":
                $scope.RFDump.set.roll_rate = 400;
                $scope.RFDump.set.roll_expo = 50;
                $scope.RFDump.set.roll_acrop = 140;
                $scope.RFDump.set.pitch_rate = 400;
                $scope.RFDump.set.pitch_expo = 50;
                $scope.RFDump.set.pitch_acrop = 140;
                $scope.RFDump.set.yaw_rate = 400;
                $scope.RFDump.set.yaw_expo = 50;
                $scope.RFDump.set.yaw_acrop = 140;
                break;
            case "5":
                $scope.RFDump.set.roll_rate = 0.7;
                $scope.RFDump.set.roll_expo = 0.4;
                $scope.RFDump.set.roll_acrop = 0.7;
                $scope.RFDump.set.pitch_rate = 0.7;
                $scope.RFDump.set.pitch_expo = 0.4;
                $scope.RFDump.set.pitch_acrop = 0.7;
                $scope.RFDump.set.yaw_rate = 0.7;
                $scope.RFDump.set.yaw_expo = 0.4;
                $scope.RFDump.set.yaw_acrop = 0.7;
                break;
            case "7":
                $scope.RFDump.set.roll_rate = 0.7;
                $scope.RFDump.set.roll_expo = 0;
                $scope.RFDump.set.roll_acrop = 1;
                $scope.RFDump.set.pitch_rate = 0.7;
                $scope.RFDump.set.pitch_expo = 0;
                $scope.RFDump.set.pitch_acrop = 1;
                $scope.RFDump.set.yaw_rate = 0.7;
                $scope.RFDump.set.yaw_expo = 0;
                $scope.RFDump.set.yaw_acrop = 1;
                break;
        }

        $scope.updateRateData();
    };

    $scope.changeFilterLevel = function(level) {
        switch (level) {
            case "ultralow":
                $scope.RFDump.set.roll_ga     = 0;
                $scope.RFDump.set.roll_quick  = 90;
                $scope.RFDump.set.pitch_ga    = 0;
                $scope.RFDump.set.pitch_quick = 90;
                $scope.RFDump.set.yaw_ga      = 0;
                $scope.RFDump.set.yaw_quick   = 60;
                break;
            case "low":
                $scope.RFDump.set.roll_ga     = 0;
                $scope.RFDump.set.roll_quick  = 60;
                $scope.RFDump.set.pitch_ga    = 0;
                $scope.RFDump.set.pitch_quick = 60;
                $scope.RFDump.set.yaw_ga      = 4;
                $scope.RFDump.set.yaw_quick   = 30;
                break;
            case "normal":
                $scope.RFDump.set.roll_ga     = 0;
                $scope.RFDump.set.roll_quick  = 45;
                $scope.RFDump.set.pitch_ga    = 0;
                $scope.RFDump.set.pitch_quick = 45;
                $scope.RFDump.set.yaw_ga      = 8;
                $scope.RFDump.set.yaw_quick   = 20;
                break;
            case "high":
                $scope.RFDump.set.roll_ga     = 0;
                $scope.RFDump.set.roll_quick  = 25;
                $scope.RFDump.set.pitch_ga    = 0;
                $scope.RFDump.set.pitch_quick = 25;
                $scope.RFDump.set.yaw_ga      = 12;
                $scope.RFDump.set.yaw_quick   = 10;
                break;
        }
    };

    function calcRate(rcCommand, rate, expo, acrop, curveToUse) {
        var maxOutput, maxOutputMod, returnValue;
        var flopSuperRate, flopRcRate, flopExpo, flopFactor;
        var kissSetpoint, kissRate, kissGRate, kissUseCurve, kissTempCurve, kissRpyUseRates, kissRxRaw, kissAngle;

        maxOutput = 1;
        maxOutputMod = 0.01;

        function constrain(amt, low, high) {
            if (amt < low)
                return low;
            else if (amt > high)
                return high;
            return amt;
        }


        function power(base, exp) {
            var result;

            result = base;
            for (var count = 1; count < exp; count++) {
                result *= base;
            }

            return (result);
        }


        switch (curveToUse) {
            case 3:
                returnValue = ((maxOutput + maxOutputMod * expo * (rcCommand * rcCommand - 1.0)) * rcCommand);
                returnValue = (returnValue * (rate + (rate * acrop * 0.01)));
                return (returnValue);
                break;
            case 4:
                returnValue = ((maxOutput + maxOutputMod * expo * (rcCommand * rcCommand - 1.0)) * rcCommand);
                returnValue = (returnValue * (rate + (Math.abs(returnValue) * rate * acrop * 0.01)));
                return (returnValue);
                break;
            case 5:
                kissUseCurve = expo;
                kissRate = acrop;
                kissGRate = rate;
                kissSetpoint = rcCommand;

                kissRpyUseRates = 1 - Math.abs(rcCommand) * kissGRate;
                kissRxRaw = rcCommand * 1000;
                kissTempCurve = (kissRxRaw * kissRxRaw / 1000000);
                kissSetpoint = ((kissSetpoint * kissTempCurve) * kissUseCurve + kissSetpoint * (1 - kissUseCurve)) * (kissRate / 10);
                kissAngle = ((2000.0 * (1.0 / kissRpyUseRates)) * kissSetpoint); //setpoint is calculated directly here
                return (kissAngle);
                break;
            case 7:
                flopExpo = expo;
                flopRcRate = acrop;
                flopSuperRate = rate;

                if (flopRcRate > 2.0)
                    flopRcRate = flopRcRate + (14.55 * (flopRcRate - 1997.0));

                if (flopExpo != 0.0)
                    rcCommand = rcCommand * power(Math.abs(rcCommand), 3) * flopExpo + rcCommand * (1.0 - flopExpo);

                var flopAngle = 200.0 * flopRcRate * rcCommand;

                if (flopSuperRate != 0.0) {
                    flopFactor = 1.0 / (constrain(1.0 - (Math.abs(rcCommand) * (flopSuperRate)), 0.01, 1.00));
                    flopAngle *= flopFactor; //setpoint is calculated directly here
                }
                return (flopAngle);
                break;
            default:
                return (rcCommand); //same as default for now.
                break;

        }
    }

    $scope.updateRateData = function() {
        var roll_table = [];
        var pitch_table = [];
        var yaw_table = [];
        var labels = [];
        var numberOfPoints = 40.0;
        var stick_curve = parseInt($scope.RFDump.set.stick_curve);

        for (var i = 0; i <= numberOfPoints; i++) {
            var point = 1.0 / numberOfPoints * i;
            roll_table[i] = calcRate(point, $scope.RFDump.set.roll_rate, $scope.RFDump.set.roll_expo, $scope.RFDump.set.roll_acrop, stick_curve);
            pitch_table[i] = calcRate(point, $scope.RFDump.set.pitch_rate, $scope.RFDump.set.pitch_expo, $scope.RFDump.set.pitch_acrop, stick_curve);
            yaw_table[i] = calcRate(point, $scope.RFDump.set.yaw_rate, $scope.RFDump.set.yaw_expo, $scope.RFDump.set.yaw_acrop, stick_curve);
            labels[i] = parseInt(point * 100) + "%";
        }

        $scope.rateGraphData = [
            roll_table,
            pitch_table,
            yaw_table
        ];
        $scope.rateGraphLabels = labels;
        $scope.rateGraphDatasetOverride = [{
                label: $translate.instant("ROLL"),
                fill: false,
                data: roll_table
            },
            {
                label: $translate.instant("PITCH"),
                fill: false,
                data: pitch_table
            },
            {
                label: $translate.instant("YAW"),
                fill: false,
                data: yaw_table
            }
        ];

        $scope.rateGraphOptions = {
            legend: {
                display: true
            },

            tooltips: {
                callbacks: {
                    label: function(tooltipItem, data) {
                        var label = data.datasets[tooltipItem.datasetIndex].label;
                        var val = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index].toFixed(2);
                        return label + ': ' + val;
                    }
                }
            },

            xAxes: [{
                display: false
            }]
        };

        var roll_rateDps = calcRate(1.0, $scope.RFDump.set.roll_rate, $scope.RFDump.set.roll_expo, $scope.RFDump.set.roll_acrop, stick_curve);
        var roll_rateRotations = Math.round($scope.roll_rateDps / 360.0 * 10.0) / 10.0;
        $scope.roll_rateDps = roll_rateDps.toFixed(2);
        $scope.roll_rateRotations = roll_rateRotations.toFixed(2);

        var pitch_rateDps = calcRate(1.0, $scope.RFDump.set.pitch_rate, $scope.RFDump.set.pitch_expo, $scope.RFDump.set.pitch_acrop, stick_curve);
        var pitch_rateRotations = Math.round($scope.pitch_rateDps / 360.0 * 10.0) / 10.0;
        $scope.pitch_rateDps = pitch_rateDps.toFixed(2);
        $scope.pitch_rateRotations = pitch_rateRotations.toFixed(2);

        var yaw_rateDps = calcRate(1.0, $scope.RFDump.set.yaw_rate, $scope.RFDump.set.yaw_expo, $scope.RFDump.set.yaw_acrop, stick_curve);
        var yaw_rateRotations = Math.round($scope.yaw_rateDps / 360.0 * 10.0) / 10.0;
        $scope.yaw_rateDps = yaw_rateDps.toFixed(2);
        $scope.yaw_rateRotations = yaw_rateRotations.toFixed(2);
    };

    $scope.updateRateData();

    $scope.save = function(ev) {
        if (!$scope.pidTuningForm.$valid) {
            return
        }

        var changedKeys = [];

        for (var inputVal in $scope.RFDump['set']) {
            if ($scope.RFDump['set'].hasOwnProperty(inputVal) &&
                $scope.RFFWHID.RFDump['set'].hasOwnProperty(inputVal) &&
                $scope.RFDump['set'][inputVal] != $scope.RFFWHID.RFDump['set'][inputVal]) {
                changedKeys.push(inputVal);
            }
        }

        if (changedKeys.length) {
            $mdDialog.show({
                controller: 'loadingDialogCtrl',
                templateUrl: 'tmpl/loadingDialog.tmpl.html',
                onComplete: function(dialogScope, element) {
                    var progressStep = 100 / changedKeys.length - 2; //count of set + save + dump commands
                    dialogScope.status = $translate.instant("SAVING");

                    function saveVar(step) {
                        $timeout(function() {
                            if ($scope.RFDump.hasOwnProperty('set') && $scope.RFDump.set.hasOwnProperty(changedKeys[step])) {
                                dialogScope.additionalStatus = $translate.instant("rffwhid.pid_tuning.SET_VARIABLE_ADDITIONAL_STATUS", { 'varName': changedKeys[step] });

                                $scope.RFFWHID.setVar({
                                    varName: changedKeys[step],
                                    varValue: $scope.RFDump['set'][changedKeys[step]],
                                    success: function() {
                                        $timeout(function() {
                                            dialogScope.progress += progressStep;
                                            step += 1;
                                            if (step < changedKeys.length) {
                                                saveVar(step);
                                            } else {
                                                $timeout(function() {
                                                    dialogScope.additionalStatus = $translate.instant("SAVING_VARIABLES");
                                                    $scope.RFFWHID.save({
                                                        success: function() {
                                                            $timeout(function() {
                                                                dialogScope.additionalStatus = $translate.instant("GETTING_NEW_DATA");
                                                                dialogScope.progress += progressStep;
                                                                $scope.RFFWHID.dump({
                                                                    populateDump: true,
                                                                    success: function() {
                                                                        $timeout(function() {
                                                                            dialogScope.progress += progressStep;
                                                                            $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
                                                                            $mdDialog.hide();
                                                                            $scope.updateRateData('roll');
                                                                        }, 0);
                                                                    },
                                                                    error: function(err) {
                                                                        $mdDialog.hide();
                                                                        RFHelper.showOkDialog(err.name, err.message);
                                                                    }
                                                                });
                                                            }, 0);
                                                        },
                                                        error: function(err) {
                                                            $mdDialog.hide();
                                                            RFHelper.showOkDialog(err.name, err.message);
                                                        }
                                                    });
                                                }, 0);
                                            }
                                        }, 0);
                                    },
                                    error: function(err) {
                                        $mdDialog.hide();
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                            }
                        }, 0);
                    }

                    saveVar(0);
                }
            });
        }
    };

    $scope.reset = function(ev) {
        RFHelper.showConfirmDialog(
            $translate.instant("rffwhid.pid_tuning.RESET_CHANGES_CONFIRM_DIALOG_TITLE"),
            $translate.instant("rffwhid.pid_tuning.RESET_CHANGES_CONFIRM_DIALOG_CONTENT")
        ).then(function() {
            $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
            $scope.updateRateData('roll');
        });
    };
});