app.directive('focusMe', function($timeout) {
    return {
        link: function(scope, element, attrs) {
            scope.$watch(attrs.focusMe, function(value) {
                if(value === true) {
                    $timeout(function() {
                        element[0].focus();
                        scope[attrs.focusMe] = false;
                    }, 0);
                }
            });
        }
    };
});

app.directive("telemetryModelViewer", ['$window', function ($window) {
    return {
        link: function (scope, elem, attr) {
            elem.ready(function () {
                var elemWidth = elem[0].offsetWidth;
                var elemHeight = elem[0].offsetHeight;

                var telemData = {};

                var scene = new THREE.Scene();
                var camera = new THREE.PerspectiveCamera(50, elemWidth/elemHeight, 1, 1000);
                var renderer = new THREE.WebGLRenderer({
                    alpha: true,
                    antialias: true
                });
                var modelWrapper = new THREE.Object3D();
                var model;
                var model_file = 'drone';
                var loader = new THREE.JSONLoader();

                // some light
                var light = new THREE.AmbientLight(0x404040);
                var light2 = new THREE.DirectionalLight(new THREE.Color(0.5, 0.5, 0.5), 1.5);

                renderer.setSize(elemWidth, elemHeight);

                elem[0].appendChild(renderer.domElement);

                loader.load('./resources/models/' + model_file + '.json', function (geometry, materials) {
                    var modelMaterial = new THREE.MeshFaceMaterial(materials);
                    model = new THREE.Mesh(geometry, modelMaterial);

                    model.scale.set(15, 15, 15);

                    modelWrapper.add(model);
                    scene.add(modelWrapper);

                    render();
                });


                light2.position.set(0, 1, 0);

                // move camera away from the model
                camera.position.x = 0;
                camera.position.y = 0;
                camera.position.z = 200;

                // add camera, model, light to the foreground scene
                scene.add(light);
                scene.add(light2);
                scene.add(camera);
                scene.add(modelWrapper);

                function render (){

                    if (!model) {
                        return;
                    }

                    var quaternion = new THREE.Quaternion().set(
                        telemData["qy"],
                        telemData["qz"],
                        telemData["qx"],
                        telemData["qw"]
                    ).normalize();

                    model.quaternion.copy(quaternion);
  
                    renderer.render(scene, camera);
                }
                render();

                // handle canvas resize
                function onWindowResize() {
                    elemWidth = elem[0].offsetWidth;
                    elemHeight = elem[0].offsetHeight;

                    renderer.setSize(elemWidth, elemHeight);
                    camera.aspect = elemWidth / elemHeight;
                    camera.updateProjectionMatrix();
                }

                angular.element($window).on('resize', onWindowResize);

                function cleanUp() {
                    angular.element($window).off('resize', onWindowResize);
                }

                scope.$on('$destroy', cleanUp);

                scope.$watch(attr.telem, function (val) {
                    telemData = val;
                    render();
                });

            });
        }
    }
}
]);