---
title: Notes
anchor: notes
---
### Previous versions

Version 2 has a completely different API than earlier versions.

Most earlier version options have current equivalents or are the same.

Please use the documentation that is available on [chartjs.org](http://www.chartjs.org/docs/) for the current version of Chart.js.

Please note - documentation for previous versions are available on the GitHub repo.

- [1.x Documentation](https://github.com/chartjs/Chart.js/tree/v1.1.1/docs)

### Browser support

Chart.js offers support for all browsers where canvas is supported.

Browser support for the canvas element is available in all modern & major mobile browsers <a href="http://caniuse.com/#feat=canvas" target="_blank">(http://caniuse.com/#feat=canvas)</a>.

Thanks to <a href="https://browserstack.com" target="_blank">BrowserStack</a> for allowing our team to test on thousands of browsers.


### Bugs & issues

Please report these on the GitHub page - at <a href="https://github.com/chartjs/Chart.js" target="_blank">github.com/chartjs/Chart.js</a>. If you could include a link to a simple <a href="http://jsbin.com/" target="_blank">jsbin</a> or similar to demonstrate the issue, that'd be really helpful.


### Contributing

New contributions to the library are welcome, but we ask that you please follow these guidelines:

- Use tabs for indentation, not spaces.
- Only change the individual files in `/src`.
- Check that your code will pass `eslint` code standards, `gulp lint` will run this for you.
- Check that your code will pass tests, `gulp test` will run tests for you.
- Keep pull requests concise, and document new functionality in the relevant `.md` file.
- Consider whether your changes are useful for all users, or if creating a Chart.js plugin would be more appropriate.

### License

Chart.js is <a href="https://github.com/chartjs/Chart.js" target="_blank">open source</a> and available under the <a href="http://opensource.org/licenses/MIT" target="_blank">MIT license</a>.

### Charting Library Comparison

Library Features

| Feature | Chart.js | D3 | HighCharts | Chartist |
| ------- | -------- | --- | ---------- | -------- |
| Completely Free | ✓ | ✓ | | ✓ |
| Canvas | ✓ | | | |
| SVG | | ✓ | ✓ | ✓ |
| Built-in Charts | ✓ | | ✓ | ✓ |
| 8+ Chart Types | ✓ | ✓ | ✓ | |
| Extendable to Custom Charts | ✓ | ✓ | |  |
| Supports Modern Browsers | ✓ | ✓ | ✓ | ✓ |
| Extensive Documentation | ✓ | ✓ | ✓ | ✓ |
| Open Source | ✓ | ✓ | ✓ | ✓ |

Built in Chart Types

| Type | Chart.js | HighCharts | Chartist |
| ---- | -------- | ---------- | -------- |
| Combined Types | ✓ | ✓ | |
| Line | ✓ | ✓ | ✓ |
| Bar | ✓ | ✓ | ✓ |
| Horizontal Bar | ✓ | ✓ | ✓ |
| Pie/Doughnut | ✓ | ✓ | ✓ |
| Polar Area | ✓ | ✓ | |
| Radar | ✓ |  | |
| Scatter | ✓ | ✓ | ✓ |
| Bubble | ✓ | | |
| Gauges | | ✓ | |
| Maps (Heat/Tree/etc.) | | ✓ | |

### Popular Plugins

There are many plugins that add additional functionality to Chart.js. Some particularly notable ones are listed here. In addition, many plugins can be found on the [Chart.js GitHub organization](https://github.com/chartjs).

 - <a href="https://github.com/chartjs/Chart.Zoom.js" target="_blank">Chart.Zoom.js</a> - Enable zooming and panning on charts
 - <a href="https://github.com/chartjs/Chart.Annotation.js" target="_blank">Chart.Annotation.js</a> - Draw lines and boxes on chart area
 - <a href="https://github.com/chartjs/Chart.BarFunnel.js" target="_blank">Chart.BarFunnel.js</a> - Adds a bar funnel chart type
 - <a href="https://github.com/chartjs/Chart.Deferred.js" target="_blank">Chart.Deferred.js</a> - Defer initial chart update until chart scrolls into viewport
 - <a href="https://github.com/chartjs/Chart.smith.js" target="_blank">Chart.Smith.js</a> - Adds a smith chart type
 - <a href="https://github.com/chartjs/Chart.LinearGauge.js" target="_blank">Chart.LinearGauge.js</a> - Adds a linear gauge chart type

### Popular Extensions

There are many extensions which are available for use with popular frameworks. Some particularly notable ones are listed here.

#### Angular
 - <a href="https://github.com/jtblin/angular-chart.js" target="_blank">angular-chart.js</a>
 - <a href="https://github.com/carlcraig/tc-angular-chartjs" target="_blank">tc-angular-chartjs</a>
 - <a href="https://github.com/petermelias/angular-chartjs" target="_blank">angular-chartjs</a>
 - <a href="https://github.com/earlonrails/angular-chartjs-directive" target="_blank">Angular Chart-js Directive</a>

#### React
 - <a href="https://github.com/topdmc/react-chartjs2" target="_blank">react-chartjs2</a>
 - <a href="https://github.com/gor181/react-chartjs-2" target="_blank">react-chartjs-2</a>

#### Django
 - <a href="https://github.com/novafloss/django-chartjs" target="_blank">Django Chartjs</a>

#### Ruby on Rails
 - <a href="https://github.com/airblade/chartjs-ror" target="_blank">chartjs-ror</a>

#### Laravel
 - <a href="https://github.com/fxcosta/laravel-chartjs" target="_blank">laravel-chartjs</a>
