'use strict';

angular.module('rfApp.rffwhid_wizard_wiz_mot', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
        name: "rffwhid.rffwhid_wizard_wiz_mot_step_1",
        url: "/rffwhid_wizard_wiz_mot_step_1",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_wiz_mot_step1.html",
        controller: 'rffwhidWizardWizMotStep1Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_wiz_mot_step_2",
        url: "/rffwhid_wizard_wiz_mot_step_2",
        templateUrl: "views/rffwhid_setup/rffwhid_wizard_wiz_mot_step2.html",
        controller: 'rffwhidWizardWizMotStep2Ctrl'
    });
}]).controller('rffwhidWizardWizMotStep1Ctrl', function($scope, $timeout, $mdDialog, $state, $translate, RFHelper) {
    $scope.propsRemoved = false;
    $scope.busy = false;

    $scope.next = function () {
        $scope.busy = true;
        $mdDialog.show({
            controller: 'loadingDialogCtrl',
            templateUrl: 'tmpl/loadingDialog.tmpl.html',
            onComplete: function (dialogScope, element) {
                dialogScope.status = $translate.instant("rffwhid.rffwhid_wizard_wiz_mot_step_1.MOTOR_CALIBRATION_DIALOG_STATUS");
                $scope.RFFWHID.wizMot({
                    index: 1,
                    success: function (wizMot1Data) {
                        function runWizMot2() {
                            $timeout(function() {
                                $scope.RFFWHID.wizMot({
                                    index: 2,
                                    success: function () {
                                        $scope.busy = false;
                                        $mdDialog.hide();
                                        $state.go('rffwhid.rffwhid_wizard_wiz_mot_step_2');
                                    },
                                    error: function (err) {
                                        $mdDialog.hide();
                                        $scope.busy = false;
                                        RFHelper.showOkDialog(err.name, err.message);
                                    }
                                });
                            }, 0);
                        }

                        for (var j=0; j<wizMot1Data.length; j++) {
                            if (wizMot1Data[j].match(/#me Plug in battery/)) {
                                $mdDialog.hide();
                                RFHelper.showOkDialog($translate.instant("INFO"),
                                    $translate.instant("rffwhid.rffwhid_wizard_wiz_mot_step_1.MOTOR_CALIBRATION_PLUGIN_BATTERY_CONFIRM_DIALOG_CONTENT")).then(function () {
                                    runWizMot2();
                                });
                            } else {
                                runWizMot2();
                            }
                        }


                    },
                    error: function (err) {
                        $mdDialog.hide();
                        $scope.busy = false;
                        RFHelper.showOkDialog(err.name, err.message);
                    }
                });
            }
        });
    };
}).controller('rffwhidWizardWizMotStep2Ctrl', function($scope, $timeout, $mdDialog, $state, $translate, RFHelper) {

});