'use strict';

angular.module('rfApp.rffwhid_console', [
    'ui.router',
    'pascalprecht.translate'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider
        .state({
            name: "rffwhid.console",
            url: "/rffwhid_console",
            templateUrl: "views/rffwhid_console/rffwhid_console.html",
            controller: 'rffwhidConsoleCtrl'
        });
}]).factory('consoleCommandHistory', function() {
    return {
        commands: [],
        currentPos: 0,

        addCommand : function(command) {
            if (this.commands.length > 10) {
                this.commands.pop();
            }
            this.commands.unshift(command);
            return this.commands;
        }
    }
}).controller('rffwhidConsoleCtrl', function($scope, $mdDialog, $timeout, $interval, consoleCommandHistory) {
    $scope.consoleOutput = "";
    $scope.busy = false;

    $scope.getCommand = function(ev) {
        switch (ev.which) {
            case 38:
                if (ev.target) {
                    ev.target.selectionStart = ev.target.selectionEnd = ev.target.value.length;
                }
                if (consoleCommandHistory.commands.length > consoleCommandHistory.currentPos) {
                    $scope.consoleCommand = consoleCommandHistory.commands[consoleCommandHistory.currentPos];
                    if (consoleCommandHistory.currentPos < consoleCommandHistory.commands.length-1) {
                        consoleCommandHistory.currentPos += 1;
                    }
                }
                break;
            case 40:
                if (ev.target) {
                    ev.target.selectionStart = ev.target.selectionEnd = ev.target.value.length;
                }
                if (consoleCommandHistory.currentPos > 0) {
                    consoleCommandHistory.currentPos -= 1;
                    if (consoleCommandHistory.commands.length >= consoleCommandHistory.currentPos) {
                        $scope.consoleCommand = consoleCommandHistory.commands[consoleCommandHistory.currentPos];
                    }
                } else {
                    $scope.consoleCommand = "";
                }
                break;
            default:
                break;
        }

    };

    $scope.printMessage = function(mes) {
        var consoleOutputTextArea = document.getElementById("console-output");
        if (consoleOutputTextArea) {
            $scope.consoleOutput += mes+"\n";
            $timeout(function() {
                consoleOutputTextArea.scrollTop = consoleOutputTextArea.scrollHeight;
            }, 0);
        }
    };

    $scope.commandAreaKeyPress = function (ev) {
        if (ev.which == 13 && !ev.ctrlKey && $scope.consoleCommand && !$scope.busy) {
            $scope.sendConsoleCommand();
        } else if(ev.which == 13 && ev.ctrlKey) {
            if ($scope.consoleCommand) {
                $scope.consoleCommand += "\n";
            } else {
                $scope.consoleCommand = "\n";
            }
        }
    };

    $scope.sendConsoleCommand = function () {
        if (!$scope.consoleCommand) {
            return
        }

        var command = $scope.consoleCommand.trim();
        var commands = command.split('\n');
        var pos = 0;
        consoleCommandHistory.addCommand(command);
        consoleCommandHistory.currentPos = 0;
        $scope.consoleCommand = "";

        function handleCommand(data) {
            $scope.RFFWHID.sendAndReceive({
                data: data,
                success: function (reportId, data) {
                    $timeout(function(){
                        var responseStr = $scope.RFFWHID.receivedDataToStr(data);

                        if (responseStr.indexOf("Unknown Command") !== -1) {
                            $scope.printMessage(responseStr.substr(0, responseStr.indexOf("\n\0")));
                            sendChainCommands();

                        } else if (responseStr.indexOf("\n\0") !== -1) {
                            $scope.RFFWHID.buffer += responseStr.substr(0, responseStr.indexOf("\n\0")); // get rid of last package garbage
                            var splitBuffer = $scope.RFFWHID.buffer.split('\n');

                            for (var j=0; j<splitBuffer.length; j++) {
                                $scope.printMessage(splitBuffer[j]);
                            }
                            sendChainCommands();

                        } else {
                            $scope.RFFWHID.buffer += responseStr;
                            handleCommand($scope.RFFWHID.hidStrToBytes("more"));
                        }
                    }, 1)
                },
                error: function (err) {
                    $scope.printMessage(err);
                    $scope.busy = false;
                }
            });
        }

        function sendChainCommands() {
            $scope.RFFWHID.clearBuffer();

            if (pos<commands.length) {
                $scope.busy = true;
                var data = $scope.RFFWHID.hidStrToBytes(commands[pos]);
                handleCommand(data);
            } else {
                $scope.busy = false;
            }

            pos += 1;
        }

        sendChainCommands();
    };


    $scope.clearConsole = function () {
        $scope.busy = true;
        $scope.consoleOutput = "";
        $scope.busy = false;
    };
});