'use strict';

angular.module('rfApp.rffwhid_wizard_vtx', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
        name: "rffwhid.rffwhid_wizard_vtx_step_1",
        url: "/rffwhid_wizard_vtx_step_1",
        templateUrl: "views/rffwhid_configuration/rffwhid_wizard_vtx_step1.html",
        controller: 'rffwhidVtxWizardStep1Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_vtx_step_2",
        url: "/rffwhid_wizard_vtx_step_2",
        templateUrl: "views/rffwhid_configuration/rffwhid_wizard_vtx_step2.html",
        controller: 'rffwhidVtxWizardStep2Ctrl'
    }).state({
        name: "rffwhid.rffwhid_wizard_vtx_step_3",
        url: "/rffwhid_wizard_vtx_step_3",
        templateUrl: "views/rffwhid_configuration/rffwhid_wizard_vtx_step3.html"
    });
}]).controller('rffwhidVtxWizardStep1Ctrl', function($scope, $state, $timeout, $mdDialog, $q, $translate, RFHelper) {
    $scope.propsRemoved = false;
    $scope.busy = false;

    $scope.next = function () {
        $scope.busy = true;
        $state.go('rffwhid.rffwhid_wizard_vtx_step_2');
    };
}).controller('rffwhidVtxWizardStep2Ctrl', function($scope, $state, $timeout, $mdDialog, $q, $translate, RFHelper) {
    $scope.busy = false;
    $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);

    $scope.vtx_pitmode_names = [
        {'val': 0, 'name': $translate.instant('rffwhid.rffwhid_wizard_vtx_step_2.VTX_PITMODE_NAMES.AFTER_POWER_CYCLE_1_OPTION')},
        {'val': 1, 'name': $translate.instant('rffwhid.rffwhid_wizard_vtx_step_2.VTX_PITMODE_NAMES.ON_AFTER_POWER_CYCLE_2_OPTION')}
    ];

    $scope.next = function () {
        $scope.busy = true;
        var changedKeys = ['vtx_pitmode_type'];

        if (changedKeys.length) {
            $mdDialog.show({
                controller: 'loadingDialogCtrl',
                templateUrl: 'tmpl/loadingDialog.tmpl.html',
                onComplete: function (dialogScope, element) {
                    var progressStep = 100/changedKeys.length-5; //count of set + save + dump commands
                    dialogScope.status = $translate.instant("SAVING");
                    dialogScope.mode = 1;

                    var setVarChain = $q.when();

                    for (var i=0; i<changedKeys.length; i++) {
                        (function(index) {
                            setVarChain = setVarChain.then(function() {
                                var deferred = $q.defer();
                                $timeout(function () {
                                    dialogScope.additionalStatus = $translate.instant("rffwhid.rffwhid_wizard_vtx_step_2.SET_VARIABLE_ADDITIONAL_STATUS", { 'varName':  changedKeys[index]});
                                    $scope.RFFWHID.setVar({
                                        index: index,
                                        varName: changedKeys[index],
                                        varValue: $scope.RFDump['set'][changedKeys[index]],
                                        success: function () {
                                            $timeout(function() {
                                                dialogScope.progress += progressStep;
                                                deferred.resolve();
                                            }, 0);
                                        },
                                        error: function (err) {
                                            deferred.reject(err);
                                        }
                                    });
                                }, 0);

                                return deferred.promise;
                            }, function(err) {
                                return $q.reject(err);
                            });
                        })(i);
                    }

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("SAVING_VARIABLES");
                            $scope.RFFWHID.save({
                                success: function() {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    }, 0);
                                },
                                error: function(err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("GETTING_NEW_DATA");
                            dialogScope.progress += progressStep;
                            $scope.RFFWHID.dump({
                                populateDump: true,
                                success: function () {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    },0);
                                },
                                error: function (err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("rffwhid.rffwhid_wizard_vtx_step_2.VTX_MODE_STATUS");
                            $scope.RFFWHID.vtxinfo({
                                success: function() {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    }, 0);
                                },
                                error: function(err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("rffwhid.rffwhid_wizard_vtx_step_2.VTX_MODE_STATUS");
                            $scope.RFFWHID.vtxpit({
                                success: function() {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    }, 0);
                                },
                                error: function(err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("rffwhid.rffwhid_wizard_vtx_step_2.VTX_MODE_STATUS");
                            $scope.RFFWHID.vtxon({
                                success: function() {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    }, 0);
                                },
                                error: function(err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        $scope.RFDump = angular.copy($scope.RFFWHID.RFDump);
                        $mdDialog.hide();
                        $scope.busy = false;
                        $state.go('rffwhid.rffwhid_wizard_vtx_step_3');
                    }, function(err) {
                        $mdDialog.hide();
                        $scope.busy = false;
                        RFHelper.showOkDialog(err.name, err.message);
                    });
                }
            });
        } else {
            $state.go('rffwhid.rffwhid_wizard_vtx_step_3');
        }
    };
});