'use strict';

angular.module('rfApp.rffwhid', [
    'ngMaterial',
    'ngMessages',
    'ui.router',
    'pascalprecht.translate',
    'RFHelperService'
]).config(['$stateProvider', function($stateProvider) {
    $stateProvider.state({
            name: "rffwhid",
            url: "/rffwhid",
            templateUrl: "views/rffwhid/rffwhid.html",
            controller: 'rffwhidViewCtrl'
        });
}]).controller('rffwhidViewCtrl', function($scope, $state, $mdDialog, $translate, RFHelper) {
    var initTab = "setup";

    $scope.selectedItem = initTab;
    $state.go("rffwhid." + initTab);

    $scope.current_lang = $translate.use();
    $scope.configuratorVersion = nw.App.manifest["version"];

    $scope.changeTab = function (stateName) {
        if ($state.current.name == stateName) {
            //do nothing
        } else if ($state.current.name == 'rffwhid.console') {
            $mdDialog.show({
                controller: 'loadingDialogCtrl',
                templateUrl: 'tmpl/loadingDialog.tmpl.html',
                onComplete: function (dialogScope, element) {
                    dialogScope.status = "Loading board";
                    $scope.RFFWHID.dump({
                        populateDump: true,
                        success: function () {
                            $mdDialog.hide();
                            if (stateName == 'changeToRFBL') {
                                $scope.RFFWHID.rebootRFBL();
                            } else {
                                $state.go(stateName);
                            }
                        },
                        error: function (err) {
                            RFHelper.showOkDialog(err.name, err.message).then(function () {
                                if (stateName == 'changeToRFBL') {
                                    $scope.RFFWHID.rebootRFBL();
                                } else {
                                    $scope.selectedItem = stateName;
                                    $state.go(stateName);
                                }
                            });
                        }
                    });
                }
            });

        } else {
            if (stateName == 'changeToRFBL') {
                $scope.RFFWHID.rebootRFBL();
            } else {
                $scope.selectedItem = stateName;
                $state.go(stateName);
            }
        }
    };

    $scope.changeLanguage = function (langKey) {
        $translate.use(langKey);
        $scope.current_lang = langKey;
    };

});