angular.module('RFHelperService', [
    'pascalprecht.translate'
]).service('RFHelper', function ($mdDialog, $translate, $q, $timeout) {
    this.showOkDialog = function (title, textContent) {
        var deferred = $q.defer();
        $mdDialog.show({
            controller: 'confirmDialogCtrl',
            templateUrl: 'tmpl/confirmDialog.tmpl.html',
            locals: {
                title: title,
                textContent: textContent
            },
            buttons: {
                "ok": {
                    "name": $translate.instant("OK"),
                    "action": function () {
                        $mdDialog.hide();
                        deferred.resolve();
                    }
                }
            }
        });

        return deferred.promise;
    };

    this.showConfirmDialog = function(title, textContent, cancelTitle, confirmTitle) {
        var deferred = $q.defer();
        $mdDialog.show({
            controller: 'confirmDialogCtrl',
            templateUrl: 'tmpl/confirmDialog.tmpl.html',
            locals: {
                title: title,
                textContent: textContent
            },
            buttons: {
                "cancel": {
                    "name": cancelTitle || $translate.instant("CANCEL"),
                    "action": function () {
                        $mdDialog.hide();
                        deferred.reject();
                    }
                },
                "confirm": {
                    "name": confirmTitle || $translate.instant("CONFIRM"),
                    "action": function () {
                        $mdDialog.hide();
                        deferred.resolve();
                    }
                }
            }
        });
        return deferred.promise;
    };
    
    
    this.saveRFFWHIDRFDumpDialog = function (options) {
        var self = this;
        options = options || {};

        var RFFWHID = options.RFFWHID || null;
        var modifiedDump = options.modifiedDump || null;
        var successCallback = options.success || null;
        var errorCallback = options.error || null;

        if (RFFWHID == null || modifiedDump == null) {
            if (errorCallback) errorCallback(new Error("RFFWHID and modifiedDump arguments are required"));
            return
        }

        var changedKeys = [];

        for (var inputVal in modifiedDump['set']) {
            if (modifiedDump['set'].hasOwnProperty(inputVal) &&
                RFFWHID.RFDump['set'].hasOwnProperty(inputVal) &&
                modifiedDump['set'][inputVal] != RFFWHID.RFDump['set'][inputVal]) {
                changedKeys.push(inputVal);
            }
        }

        if (changedKeys.length) {
            $mdDialog.show({
                controller: 'loadingDialogCtrl',
                templateUrl: 'tmpl/loadingDialog.tmpl.html',
                onComplete: function (dialogScope, element) {
                    var progressStep = 100/changedKeys.length-2; //count of set + save + dump commands
                    dialogScope.status = $translate.instant("SAVING");
                    dialogScope.mode = 1;

                    var setVarChain = $q.when();

                    for (var i=0; i<changedKeys.length; i++) {
                        (function(index) {
                            setVarChain = setVarChain.then(function() {
                                var deferred = $q.defer();
                                $timeout(function () {
                                    dialogScope.additionalStatus = "Set variable: " + changedKeys[index];

                                    RFFWHID.setVar({
                                        index: index,
                                        varName: changedKeys[index],
                                        varValue: modifiedDump['set'][changedKeys[index]],
                                        success: function () {
                                            $timeout(function() {
                                                dialogScope.progress += progressStep;
                                                deferred.resolve();
                                            }, 0);
                                        },
                                        error: function (err) {
                                            deferred.reject(err);
                                        }
                                    });
                                }, 0);

                                return deferred.promise;
                            }, function(err) {
                                return $q.reject(err);
                            });
                        })(i);
                    }

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("SAVING_VARIABLES");
                            RFFWHID.save({
                                success: function() {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    }, 0);
                                },
                                error: function(err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        var deferred = $q.defer();
                        $timeout(function() {
                            dialogScope.additionalStatus = $translate.instant("GETTING_NEW_DATA");
                            dialogScope.progress += progressStep;
                            RFFWHID.dump({
                                populateDump: true,
                                success: function () {
                                    $timeout(function() {
                                        dialogScope.progress += progressStep;
                                        deferred.resolve();
                                    },0);
                                },
                                error: function (err) {
                                    deferred.reject(err);
                                }
                            });
                        }, 0);
                        return deferred.promise;
                    }, function(err) {
                        return $q.reject(err);
                    });

                    setVarChain = setVarChain.then(function(){
                        $mdDialog.hide();
                        if (successCallback) successCallback(RFFWHID);
                    }, function(err) {
                        $mdDialog.hide();
                        if (errorCallback) errorCallback(err);
                    });
                }
            });
        } else {
            if (errorCallback) errorCallback(new Error('Values are the same'));
        }

    }

});