angular.module('RFFWHIDRFBLService', []).service('RFFWHIDRFBL', function ($timeout) {
    this.vendorId= 1155;
    this.productId= 22337;
    this.connectionId= null;
    this.deviceInfo = null;
    this.reportSize = 63; //Device specific - 1
    this.buffer = "";

    this.connect = function(options) {
        var self = this;
        var deviceInfo = options.deviceInfo;
        var successCallback = options.success || null;
        var errorCallback = options.error || null;

        if (!deviceInfo) {
            throw new Error('deviceInfo args are required.');
        }

        chrome.hid.connect(deviceInfo.deviceId, function (connection) {
            if (!connection) {
                if (errorCallback) errorCallback(new Error('Unable to connect to device.'));
            } else {
                self.connectionId = connection.connectionId;
                self.deviceInfo = deviceInfo;
                if (successCallback) successCallback(connection.connectionId);
            }
        });
    };

    this.disconnect = function() {
        if (this.connectionId) {
            chrome.hid.disconnect(this.connectionId);
            console.log("Chrome RFBL device disconnected.")
        }
        this.connectionId = null;
        this.deviceInfo = null;
        this.buffer = [];
    };

    this.getDevices= function (callback) {
        var self = this;

        chrome.hid.getDevices({
            vendorId: self.vendorId,
            productId: self.productId
        }, function(devicesInfo) {
            var hidDevicesInfo = devicesInfo.filter(function (deviceInfo) {
                return deviceInfo.productName.indexOf("RaceFlight Boot Loader") !== -1 || deviceInfo.productName.indexOf("RaceFlight Recovery") !== -1;
            });
            callback(hidDevicesInfo);
        });
    };

    this.hidStrToBytes = function(string) {
        var pad = this.reportSize;
        var bytes = new Uint8Array(pad);
        var contents = string;
        var i;
        for (i = 0; i < contents.length && i < bytes.length; ++i) {
            if (contents.charCodeAt(i) > 255) {
                throw new Error("I am not smart enough to decode non-ASCII data.");
            }
            bytes[i] = contents.charCodeAt(i);
        }
        for (i = contents; i < bytes.length; ++i) {
            bytes[i] = pad;
        }

        return bytes;

    };

    this.receivedDataToStr = function(data) {
        return String.fromCharCode.apply(null, new Uint8Array(data));
    };

    this.clearBuffer = function () {
        this.buffer = "";
    };

    this.send = function(options) {
        var self = this;

        options = options || {};

        var data = options.data;
        var successCallback = options.success || null;
        var errorCallback = options.error || null;

        if (!data) {
            throw new Error('data args are required.');
        }

        if (chrome.runtime.lastError) {
            if (errorCallback) errorCallback(new Error('Internal HID error'));
            return
        }

        if (!self.connectionId) {
            if (errorCallback) errorCallback(new Error('Internal HID error'));
            return
        }

        chrome.hid.send(self.connectionId, 2, data.buffer, function() {
            if (successCallback) successCallback();
        });
    };

    this.receive = function(options) {
        options = options || {};

        var self = this;
        var successCallback = options.success || null;
        var errorCallback = options.error || null;

        if (chrome.runtime.lastError) {
            if (errorCallback) errorCallback(new Error('Receive failed: Internal HID error'));
            return
        }

        if (!self.connectionId) {
            if (errorCallback) errorCallback(new Error('Receive failed: connectionId not found.'));
            return
        }

        chrome.hid.receive(self.connectionId, function (reportId, data) {
            if (successCallback) successCallback(reportId, data);
        });
    };

    this.sendAndReceive = function(options) {
        var self = this;

        options = options || {};

        var data = options.data;
        var successCallback = options.success || null;
        var errorCallback = options.error || null;

        if (!data) {
            throw new Error('data args are required.');
        }

        self.send({
            data: data,
            success: function () {
                self.receive({
                    success: function(reportId, data) {
                        if (successCallback) successCallback(reportId, data);
                    },
                    error: function (err) {
                        if (errorCallback) errorCallback(err);
                    }
                });
            },
            error: function (err) {
                if (errorCallback) errorCallback(err);
            }
        });
    };

    this.sendCommand = function (options) {
        var self = this;

        options = options || {};
        var command = options.command || null;

        if (!command) {
            throw new Error('Illegal command argument for sendCommand.');
        }

        var data = self.hidStrToBytes(command);
        var successCallback = options.success || null;
        var errorCallback = options.error || null;

        self.clearBuffer();

        function handler(data) {
            self.sendAndReceive({
                data: data,
                success: function (reportId, data) {
                    $timeout(function(){
                        var responseStr = self.receivedDataToStr(data);

                        if (responseStr.indexOf("Unknown Command") !== -1) {
                            if (errorCallback) errorCallback(new Error(responseStr.indexOf("\n\0")));
                        } else if (responseStr.indexOf("\n\0") !== -1) {
                            self.buffer += responseStr.substr(0, responseStr.indexOf("\n\0")); // get rid of last package garbage
                            if (successCallback) successCallback();
                        } else {
                            self.buffer += responseStr;
                            handler(self.hidStrToBytes("more"));
                        }
                    }, 1)
                },
                error: function (err) {
                    if (errorCallback) errorCallback(err);
                }
            });
        }
        handler(data);
    };

});